/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.bioportal.BioportalOntologyService;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;
import uk.ac.ebi.ontocat.virtual.CompositeDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="term")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class OntologyTerm
implements Serializable,
Comparable<OntologyTerm> {
    private static final long serialVersionUID = 1L;
    private String accession;
    private String label;
    private String ontologyAccession;
    private URI uri = null;
    private static final Logger log = Logger.getLogger(OntologyTerm.class);
    private OntologyTermContext context = new OntologyTermContext();
    private static Map<String, Ontology> ontologyCache;

    public OntologyTerm() {
    }

    @Deprecated
    public OntologyTerm(String ontologyAccession, String termAccession, String label) {
        this.setAccession(termAccession);
        this.setLabel(label);
        this.setOntologyAccession(ontologyAccession);
    }

    public OntologyTerm(String ontologyAccession, String termAccession, String label, URI uri) {
        this.setAccession(termAccession);
        this.setLabel(label);
        this.setOntologyAccession(ontologyAccession);
        this.setURI(uri);
    }

    public String getAccession() {
        return this.accession;
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getOntologyAccession() {
        return this.ontologyAccession;
    }

    public void setOntologyAccession(String ontologyAccession) {
        this.ontologyAccession = ontologyAccession;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        return String.format("OntologyTerm(ontologyAccession=%s, termAccession=%s, termURI=%s, label=%s)", this.getOntologyAccession(), this.getAccession(), this.getURI(), this.getLabel());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAccession() == null ? 0 : this.getAccession().hashCode());
        result = 31 * result + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        result = 31 * result + (this.getOntologyAccession() == null ? 0 : this.getOntologyAccession().hashCode());
        result = 31 * result + (this.getURI() == null ? 0 : this.getURI().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OntologyTerm other = (OntologyTerm)obj;
        if (this.getAccession() == null ? other.getAccession() != null : !this.getAccession().equals(other.getAccession())) {
            return false;
        }
        if (this.getLabel() == null ? other.getLabel() != null : !this.getLabel().equals(other.getLabel())) {
            return false;
        }
        if (this.getOntologyAccession() == null ? other.getOntologyAccession() != null : !this.getOntologyAccession().equals(other.getOntologyAccession())) {
            return false;
        }
        return !(this.getURI() == null ? other.getURI() != null : !this.getURI().equals(other.getURI()));
    }

    private void initalizeOntologyCache() throws OntologyServiceException {
        if (ontologyCache == null) {
            ontologyCache = new HashMap<String, Ontology>();
            OntologyService os = CompositeDecorator.getService(new OntologyService[]{new OlsOntologyService(), new BioportalOntologyService()});
            for (Ontology o : os.getOntologies()) {
                ontologyCache.put(o.getOntologyAccession(), o);
            }
        }
    }

    public Ontology getOntology() throws OntologyServiceException {
        this.initalizeOntologyCache();
        if (ontologyCache.containsKey(this.getOntologyAccession())) {
            return ontologyCache.get(this.getOntologyAccession());
        }
        if (this.getContext().getServiceType() == OntologyServiceType.FILE) {
            return new Ontology(this.getOntologyAccession());
        }
        if (this.getContext().getServiceType() == OntologyServiceType.BIOPORTAL) {
            ontologyCache.put(this.getOntologyAccession(), new BioportalOntologyService().getOntology(this.getOntologyAccession()));
            return ontologyCache.get(this.getOntologyAccession());
        }
        throw new OntologyServiceException("Could not infer ontology!");
    }

    public OntologyTermContext getContext() {
        if (this.context == null) {
            this.context = new OntologyTermContext();
        }
        return this.context;
    }

    @Override
    public int compareTo(OntologyTerm o) {
        if (this.getContext().getSimilarityScore() > o.getContext().getSimilarityScore()) {
            return -1;
        }
        if (this.getContext().getSimilarityScore() < o.getContext().getSimilarityScore()) {
            return 1;
        }
        return 0;
    }

    public class OntologyTermContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Date timestamp = new Date();
        private Integer SimilarityScore = null;
        private OntologyService.SearchOptions[] searchOptions;
        private OntologyServiceType serviceType = OntologyServiceType.UNKNOWN;
        private String valueMatched = null;

        public String toString() {
            return "OntologyTermContext [SimilarityScore=" + this.SimilarityScore + ", valueMatched=" + this.valueMatched + ", searchOptions=" + Arrays.toString((Object[])this.searchOptions) + ", serviceType=" + (Object)((Object)this.getServiceType()) + ", timestamp=" + this.timestamp + "]";
        }

        public OntologyServiceType getServiceType() {
            return this.serviceType;
        }

        public void setServiceType(OntologyServiceType serviceType) {
            this.serviceType = serviceType;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setSearchOptions(OntologyService.SearchOptions[] searchOptions) {
            this.searchOptions = searchOptions;
        }

        public OntologyService.SearchOptions[] getSearchOptions() {
            return this.searchOptions;
        }

        public Integer getSimilarityScore() {
            return this.SimilarityScore;
        }

        public String getValueMatched() {
            return this.valueMatched;
        }

        private void setValueMatched(String val) {
            this.valueMatched = val;
        }

        public void setSimilarityScore(String query, String text) {
            this.setValueMatched(text);
            if (query.equalsIgnoreCase(text)) {
                this.setSimilarityScore(100);
            } else {
                int LD = StringUtils.getLevenshteinDistance((String)this.getNormalised(text), (String)this.getNormalised(query));
                int LDnorm = (int)((float)(query.length() - LD) / (float)query.length() * 100.0f);
                this.setSimilarityScore(LDnorm);
            }
        }

        private void setSimilarityScore(Integer similarityScore) {
            this.SimilarityScore = similarityScore;
        }

        private String getNormalised(String in) {
            Object[] words = in.split("[^a-z0-9]");
            Arrays.sort(words);
            StringBuilder builder = new StringBuilder();
            for (Object s : words) {
                builder.append((String)s);
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OntologyServiceType {
        OLS,
        BIOPORTAL,
        FILE,
        UNKNOWN;

    }
}

