/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractObjectRestrictionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public abstract class AbstractObjectCardinalityTranslator
extends AbstractObjectRestrictionTranslator {
    private IRI cardinalityPredicate;

    public AbstractObjectCardinalityTranslator(OWLRDFConsumer consumer, IRI cardinalityPredicate) {
        super(consumer);
        this.cardinalityPredicate = cardinalityPredicate;
    }

    public boolean matches(IRI mainNode) {
        if (!super.matches(mainNode)) {
            return false;
        }
        OWLLiteral lit = this.getConsumer().getLiteralObject(mainNode, this.cardinalityPredicate, false);
        if (lit == null) {
            return false;
        }
        if (this.getConsumer().getConfiguration().isStrict()) {
            OWL2Datatype xsdNNI = OWL2Datatype.XSD_NON_NEGATIVE_INTEGER;
            return xsdNNI.getIRI().equals(lit.getDatatype().getIRI()) && xsdNNI.isInLexicalSpace(lit.getLiteral());
        }
        return true;
    }

    public boolean matchesOnPropertyObject(IRI onPropertyObject) {
        return this.getConsumer().isObjectProperty(onPropertyObject);
    }

    protected int translateCardinality(IRI mainNode) {
        OWLLiteral con = this.getConsumer().getLiteralObject(mainNode, this.cardinalityPredicate, true);
        return Integer.parseInt(con.getLiteral().trim());
    }
}

