### R code from vignette source 'miRNAtap.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: miRNAtap.Rnw:73-75 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite()


###################################################
### code chunk number 2: miRNAtap.Rnw:81-84 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("miRNAtap")
## biocLite("miRNAtap.db")


###################################################
### code chunk number 3: miRNAtap.Rnw:99-102 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("topGO")
## biocLite("org.Hs.eg.db")


###################################################
### code chunk number 4: miRNAtap.Rnw:107-110
###################################################
library(miRNAtap)
library(topGO)
library(org.Hs.eg.db)


###################################################
### code chunk number 5: miRNAtap.Rnw:116-119
###################################################
mir = 'miR-10b'
predictions = getPredictedTargets(mir, species = 'hsa',
                                    method = 'geom', min_src = 2)


###################################################
### code chunk number 6: miRNAtap.Rnw:124-125
###################################################
head(predictions)


###################################################
### code chunk number 7: miRNAtap.Rnw:134-137
###################################################
predictions_min = getPredictedTargets(mir, species = 'hsa',
                                    method = 'min', min_src = 2)
head(predictions_min)


###################################################
### code chunk number 8: miRNAtap.Rnw:146-148
###################################################
predictions_rat = getPredictedTargets(mir, species = 'rno',
                                    method = 'geom', min_src = 2)


###################################################
### code chunk number 9: miRNAtap.Rnw:155-163
###################################################
rankedGenes = predictions[,'rank_product']
selection = function(x) TRUE 
# we do not want to impose a cut off, instead we are using rank information
allGO2genes = annFUN.org(whichOnto='BP', feasibleGenes = NULL,
                mapping="org.Hs.eg.db", ID = "entrez")
GOdata =  new('topGOdata', ontology = 'BP', allGenes = rankedGenes, 
            annot = annFUN.GO2genes, GO2genes = allGO2genes, 
            geneSel = selection, nodeSize=10)


###################################################
### code chunk number 10: miRNAtap.Rnw:169-171
###################################################
results.ks = runTest(GOdata, algorithm = "classic", statistic = "ks")
results.ks


###################################################
### code chunk number 11: miRNAtap.Rnw:177-179
###################################################
allRes = GenTable(GOdata, KS = results.ks, orderBy = "KS", topNodes = 20)
allRes[,c('GO.ID','Term','KS')]


###################################################
### code chunk number 12: miRNAtap.Rnw:190-191
###################################################
toLatex(sessionInfo())


