### R code from vignette source 'covEB.Rnw'

###################################################
### code chunk number 1: covEB.Rnw:30-31
###################################################
options(width=60)


###################################################
### code chunk number 2: covEB.Rnw:39-48
###################################################
library(covEB)
 	sigma <- matrix(c(4,2,2,3), ncol=2)
	x <- rmvnorm(n=500, mean=c(1,2), sigma=sigma)
 
 	samplecov<-cov(x)
 
 	test<-covEB(samplecov,delta=0.05,shift=0.025,startlambda=0.4,n=500)




###################################################
### code chunk number 3: covEB.Rnw:55-60
###################################################
library(curatedBladderData)

data(package="curatedBladderData")
data(GSE89_eset)
Edata<-exprs(GSE89_eset)


###################################################
### code chunk number 4: covEB.Rnw:65-71
###################################################
variances<-apply(Edata,1,var)
edata<-Edata[which(variances>quantile(variances,0.8)),]
covmat<-cov(t(edata))
cormat<-cov2cor(covmat)
#we are now able to use covmat as input into covEB:
out<-covEB(covmat,0.2,0.1,startlambda=0.6,n=40)


###################################################
### code chunk number 5: covEB.Rnw:75-78
###################################################
outmat<-out
outmat[abs(out)<0.65]<-0
outmat[abs(out)>=0.65]<-1


###################################################
### code chunk number 6: covEB.Rnw:81-90
###################################################
clusth<-clusters(graph.adjacency(outmat))
sel<-which(clusth$membership==5)
subgraphEB<-outmat[sel,sel]
subgraph<-cormat[sel,sel]
subgraph[subgraph<0.65]<-0
subgraph[subgraph>=0.65]<-1

diag(subgraph)<-0
diag(subgraphEB)<-0


###################################################
### code chunk number 7: covEB.Rnw:93-96 (eval = FALSE)
###################################################
## 
## plot(graph.adjacency(subgraph,mode="undirected"))
## plot(graph.adjacency(subgraphEB,mode="undirected"))


