## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----label = settings, echo = FALSE, eval = TRUE-----
options(width = 55)

## ----label = loadpackage, echo = TRUE, eval = TRUE, results = 'hide', message = FALSE----
library(compcodeR)

## ----label = simulatedata, echo = TRUE, eval = FALSE, tidy = FALSE----
#  B_625_625 <- generateSyntheticData(dataset = "B_625_625", n.vars = 12500,
#                                     samples.per.cond = 5, n.diffexp = 1250,
#                                     repl.id = 1, seqdepth = 1e7,
#                                     fraction.upregulated = 0.5,
#                                     between.group.diffdisp = FALSE,
#                                     filter.threshold.total = 1,
#                                     filter.threshold.mediancpm = 0,
#                                     fraction.non.overdispersed = 0,
#                                     output.file = "B_625_625_5spc_repl1.rds")

## ----label = reportsimulated, echo = TRUE, eval = FALSE, tidy = FALSE----
#  summarizeSyntheticDataSet(data.set = "B_625_625_5spc_repl1.rds",
#                            output.filename = "B_625_625_5spc_repl1_datacheck.html")

## ----label = rundiffexp1, echo = TRUE, eval = FALSE, tidy = FALSE----
#  runDiffExp(data.file = "B_625_625_5spc_repl1.rds",
#             result.extent = "voom.limma", Rmdfunction = "voom.limma.createRmd",
#             output.directory = ".", norm.method = "TMM")
#  runDiffExp(data.file = "B_625_625_5spc_repl1.rds",
#             result.extent = "edgeR.exact", Rmdfunction = "edgeR.exact.createRmd",
#             output.directory = ".", norm.method = "TMM",
#             trend.method = "movingave", disp.type = "tagwise")
#  runDiffExp(data.file = "B_625_625_5spc_repl1.rds", result.extent = "ttest",
#             Rmdfunction = "ttest.createRmd",
#             output.directory = ".", norm.method = "TMM")

## ----label = listcreatermd, echo = TRUE, eval = TRUE----
listcreateRmd()

## ----label = runcomparison, echo = TRUE, eval = FALSE, tidy = FALSE----
#  runComparisonGUI(input.directories = ".",
#                   output.directory = ".", recursive = FALSE)

## ----label = generatecode, echo = TRUE, eval = FALSE----
#  generateCodeHTMLs("B_625_625_5spc_repl1_ttest.rds", ".")

## ----label = nogui-comparison, echo = TRUE, eval = FALSE, tidy = FALSE----
#  file.table <- data.frame(input.files = c("B_625_625_5spc_repl1_voom.limma.rds",
#                                           "B_625_625_5spc_repl1_ttest.rds",
#                                           "B_625_625_5spc_repl1_edgeR.exact.rds"),
#                           stringsAsFactors = FALSE)
#  parameters <- list(incl.nbr.samples = NULL, incl.replicates = NULL,
#                     incl.dataset = "B_625_625", incl.de.methods = NULL,
#                     fdr.threshold = 0.05, tpr.threshold = 0.05,
#                     typeI.threshold = 0.05, ma.threshold = 0.05,
#                     fdc.maxvar = 1500, overlap.threshold = 0.05,
#                     fracsign.threshold = 0.05,
#                     comparisons = c("auc", "fdr", "tpr", "ma", "correlation"))
#  runComparison(file.table = file.table, parameters = parameters, output.directory = ".")

## ----create-compData, eval = TRUE, tidy = FALSE------
count.matrix <- matrix(round(1000*runif(4000)), 1000, 4)
sample.annot <- data.frame(condition = c(1, 1, 2, 2))
info.parameters <- list(dataset = "mytestdata", uID = "123456")
cpd <- compData(count.matrix = count.matrix, 
                sample.annotations = sample.annot, 
                info.parameters = info.parameters)
check_compData(cpd)

## ----label = savedata, echo = TRUE, eval = FALSE-----
#  saveRDS(cpd, "saveddata.rds")

## ----session-info, eval = TRUE, echo = FALSE, results="asis"----
toLatex(sessionInfo())

