## ----style, echo = FALSE, results = 'asis', warning=FALSE----------------
suppressPackageStartupMessages(library(bacon))
BiocStyle::markdown()

## ----simulateddata1, message=FALSE---------------------------------------
set.seed(12345)
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
bc <- bacon(y)
bc
estimates(bc)
inflation(bc)
bias(bc)

## ----gsoutput------------------------------------------------------------
traces(bc, burnin=FALSE)
posteriors(bc)
fit(bc, n=100)

## ----plothist1-----------------------------------------------------------
plot(bc, type="hist")
plot(bc, type="qq")

## ----simulateddata2, message=FALSE---------------------------------------
set.seed(12345)
es <- replicate(6, rnormmix(2000, c(0.9, 0, 1, 0, 4, 1)))
se <- replicate(6, 0.8*sqrt(4/rchisq(2000,df=4)))
colnames(es) <- colnames(se) <- LETTERS[1:ncol(se)]
rownames(es) <- rownames(se) <- 1:2000
head(rownames(es))
head(colnames(es))

## ----runbacon------------------------------------------------------------
library(BiocParallel)
register(MulticoreParam(1, log=TRUE))
bc <- bacon(NULL, es, se)
bc
estimates(bc)
inflation(bc)
bias(bc)
head(tstat(bc))
head(pval(bc))
head(se(bc))
head(es(bc))

## ----traces2-------------------------------------------------------------
traces(bc, burnin=FALSE, index=3)
posteriors(bc, index=3)
fit(bc, index=3, n=100)


## ----plothist2-----------------------------------------------------------
plot(bc, type="hist")

## ----qqplot2-------------------------------------------------------------
plot(bc, type="qq")

## ----meta----------------------------------------------------------------
bcm <- meta(bc)
head(pval(bcm))
plot(bcm, type="qq")
(topTable(bcm))

## ----session info, echo=FALSE--------------------------------------------
sessionInfo()

