## ----style-knitr, eval=TRUE, echo=FALSE, results='asis'---------------------------------
BiocStyle::latex()

## ----opts, include=FALSE, echo=FALSE----------------------------------------------------
knitr::opts_chunk$set(concordance = TRUE, 
                      eval = TRUE,
                      cache = FALSE,
                      resize.width="0.45\\textwidth",
                      fig.align='center',
                      tidy = FALSE,
                      message=FALSE)

## ----install, eval=FALSE----------------------------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("TPP")

## ----package----------------------------------------------------------------------------
library("TPP")

## ----load_2d_data-----------------------------------------------------------------------
data("panob2D_isobQuant_example")

## ----head_2d_data, eval=TRUE------------------------------------------------------------
config_tpp2d <- panobinostat_2DTPP_config
data_tpp2d <- panobinostat_2DTPP_data

config_tpp2d
data_tpp2d %>% str(1)

## ----colnames_Pano, eval=TRUE-----------------------------------------------------------
data_tpp2d$Experiment1 %>% colnames

## ----ttp2dworkflow, eval = TRUE---------------------------------------------------------
tpp2dResults <- analyze2DTPP(configFile = config_tpp2d, 
                             data = data_tpp2d, 
                             fcStr = NULL,
                             methods = "doseResponse", 
                             nCores = 2)

tpp2dResults %>% mutate_if(is.character, factor) %>% summary

## ----ttp2dDataImport2, eval=TRUE--------------------------------------------------------
data2d <- tpp2dImport(configTable = config_tpp2d, 
                      data = data_tpp2d, 
                      fcStr = NULL)

head(data2d)

## ----ttp2dComputeFC2, eval=TRUE---------------------------------------------------------
fcData2d <- tpp2dComputeFoldChanges(configTable = config_tpp2d,
                                    data = data2d)


## ----head_fold_changes2, eval=TRUE------------------------------------------------------
head(fcData2d)

## ----ttp2dDoMedianNorm2, eval=TRUE------------------------------------------------------
normData2d <- tpp2dNormalize(configTable = config_tpp2d,
                                data = fcData2d)

head(normData2d)
# we have to update our fcStr, if we want the normalized columns to be used in the following analysis
fcStrUpdated <- "norm_rel_fc_"

## ----tpp2dCreateCCRConfigList2, eval=TRUE-----------------------------------------------
config_ccr <- tpp2dCreateCCRConfigFile(configTable = config_tpp2d)

## ----tpp2dCurveFit, eval=TRUE, warning=FALSE--------------------------------------------
ccr2dResults <- tpp2dCurveFit(configFile = config_ccr, 
                               data = normData2d, 
                               fcStr = fcStrUpdated)

## ----tpp2dPlotGoodCurves, eval=TRUE, warning=FALSE--------------------------------------
goodCurves <- tpp2dPlotCCRGoodCurves(configTable = config_tpp2d, 
                                     data = ccr2dResults, 
                                     fcStr = fcStrUpdated)

## ----plotCurve2, eval=TRUE, fig.height=6, fig.width=7.5---------------------------------
goodCurves[["HDAC2"]]

## ----plotSingleCurves, eval=TRUE, fig.show='hide', fig.height=6, fig.width=7.5----------
singleCurve <- tpp2dPlotCCRSingleCurves(configTable = config_tpp2d, 
                                        data = ccr2dResults, 
                                        fcStr = fcStrUpdated)
singleCurve[["HDAC2"]][["54"]]

