## ----style-knitr, eval=TRUE, echo=FALSE, results='asis'---------------------------------
BiocStyle::latex()

## ----opts, include=FALSE, echo=FALSE----------------------------------------------------
knitr::opts_chunk$set(concordance=TRUE, 
                      eval = TRUE,
                      cache = FALSE,
                      resize.width="0.45\\textwidth",
                      fig.align='center',
                      tidy = FALSE,
                      message=FALSE)

## ----package----------------------------------------------------------------------------
library("TPP")

## ----load_tr_data-----------------------------------------------------------------------
data("hdacTR_smallExample")

## ----result_path_TR---------------------------------------------------------------------
resultPath = file.path(getwd(), 'NPARC_Vignette_Example')

## ----analyzeTR, eval = TRUE-------------------------------------------------------------
TRresults <- analyzeTPPTR(configTable = hdacTR_config, data = hdacTR_data, 
                          method = "splinefit", nCores = 2, resultPath = resultPath, 
                          plotCurves = FALSE) 

