## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"---------------------------------
BiocStyle::latex()

## ----include=FALSE----------------------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance = TRUE,
background = "#f3f3ff"
)

## ----req--------------------------------------------------------------------------------
library(SIMLR)
data(BuettnerFlorian)

## ----igraph, results='hide', message=FALSE----------------------------------------------
library(igraph)

## ----SIMLR_run, warning=FALSE-----------------------------------------------------------
set.seed(11111)
example = SIMLR(X = BuettnerFlorian$in_X, c = BuettnerFlorian$n_clust, cores.ratio = 0)

## ----nmi_performance--------------------------------------------------------------------
nmi_1 = compare(BuettnerFlorian$true_labs[,1], example$y$cluster, method="nmi")
print(nmi_1)

## ----image, fig.show='hide', fig.width=5, fig.height=5,results='hide'-------------------
plot(example$ydata, 
    col = c(topo.colors(BuettnerFlorian$n_clust))[BuettnerFlorian$true_labs[,1]], 
    xlab = "SIMLR component 1",
    ylab = "SIMLR component 2",
    pch = 20,
    main="SIMILR 2D visualization for Test_1_mECS")

## ----sceset, message=FALSE, warning=FALSE-----------------------------------------------
library(scran)
ncells = 100
ngenes = 50
mu <- 2^runif(ngenes, 3, 10)
gene.counts <- matrix(rnbinom(ngenes*ncells, mu=mu, size=2), nrow=ngenes)
rownames(gene.counts) = paste0("X", seq_len(ngenes))
sce = newSCESet(countData=data.frame(gene.counts))
output = SIMLR(X = sce, c = 8, cores.ratio = 0)

## ----SIMLR_Feature_Ranking_run, results='hide'------------------------------------------
ranks = SIMLR_Feature_Ranking(A=BuettnerFlorian$results$S,X=BuettnerFlorian$in_X)

## ----head-ranks-------------------------------------------------------------------------
head(ranks$pval)
head(ranks$aggR)

## ----sessioninfo, results='asis'--------------------------------------------------------
toLatex(sessionInfo())

