/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConcurrencyTools {
    private static ThreadPoolExecutor pool;

    private ConcurrencyTools() {
    }

    public static ThreadPoolExecutor getThreadPool() {
        if (pool == null || pool.isShutdown()) {
            ConcurrencyTools.setThreadPoolDefault();
        }
        return pool;
    }

    public static void setThreadPoolCPUsAvailable(int cpus) {
        ConcurrencyTools.setThreadPoolSize(Math.max(1, Runtime.getRuntime().availableProcessors() - cpus));
    }

    public static void setThreadPoolCPUsFraction(float fraction) {
        ConcurrencyTools.setThreadPoolSize(Math.max(1, Math.round(fraction * (float)Runtime.getRuntime().availableProcessors())));
    }

    public static void setThreadPoolDefault() {
        ConcurrencyTools.setThreadPoolCPUsAvailable(0);
    }

    public static void setThreadPoolSingle() {
        ConcurrencyTools.setThreadPoolSize(1);
    }

    public static void setThreadPoolSize(int threads) {
        ConcurrencyTools.setThreadPool(new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public static void setThreadPool(ThreadPoolExecutor pool) {
        if (ConcurrencyTools.pool != pool) {
            ConcurrencyTools.shutdown();
            ConcurrencyTools.pool = pool;
        }
    }

    public static void shutdown() {
        if (pool != null) {
            pool.shutdown();
        }
    }

    public static void shutdownAndAwaitTermination() {
        ConcurrencyTools.shutdown();
        if (pool != null) {
            try {
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        System.err.println("BioJava ConcurrencyTools thread pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> Future<T> submit(Callable<T> task, String message) {
        return ConcurrencyTools.getThreadPool().submit(task);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return ConcurrencyTools.submit(task, "");
    }
}

