/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.template;

import java.util.Iterator;
import java.util.List;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceView;

public class SequenceProxyView<C extends Compound>
implements SequenceView<C> {
    private Integer bioStart;
    private Integer bioEnd;
    private Sequence<C> sequence;

    public SequenceProxyView() {
    }

    public SequenceProxyView(Sequence<C> sequence) {
        this(sequence, 1, sequence.getLength());
    }

    public SequenceProxyView(Sequence<C> sequence, Integer bioStart, Integer bioEnd) {
        this.sequence = sequence;
        this.setBioStart(bioStart);
        this.setBioEnd(bioEnd);
    }

    @Override
    public Sequence<C> getViewedSequence() {
        return this.sequence;
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toString(this);
    }

    @Override
    public List<C> getAsList() {
        return SequenceMixin.toList(this);
    }

    @Override
    public C getCompoundAt(int position) {
        return this.getViewedSequence().getCompoundAt(this.getBioStart() + position - 1);
    }

    @Override
    public int getIndexOf(C compound) {
        return SequenceMixin.indexOf(this, compound);
    }

    @Override
    public int getLastIndexOf(C compound) {
        return SequenceMixin.lastIndexOf(this, compound);
    }

    @Override
    public int getLength() {
        return this.getBioEnd() - this.getBioStart() + 1;
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.getViewedSequence().getCompoundSet();
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioStart, Integer bioEnd) {
        return new SequenceProxyView<C>(this, bioStart, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return new SequenceMixin.SequenceIterator(this);
    }

    @Override
    public AccessionID getAccession() {
        return this.getViewedSequence().getAccession();
    }

    @Override
    public Integer getBioStart() {
        return this.bioStart;
    }

    public void setBioStart(Integer bioStart) {
        if (bioStart < 1) {
            throw new IllegalArgumentException("The given start " + bioStart + " is less than 1; cannot index less than 1");
        }
        this.bioStart = bioStart;
    }

    @Override
    public Integer getBioEnd() {
        return this.bioEnd;
    }

    public void setBioEnd(Integer bioEnd) {
        if (this.sequence == null) {
            throw new NullPointerException("No sequence given before setting the end coordinate; cannot be done");
        }
        this.bioEnd = bioEnd;
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }
}

