/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.search_parameters_cli;

import com.compomics.software.CommandLineUtils;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.CometParameters;
import com.compomics.util.experiment.identification.identification_parameters.DirecTagParameters;
import com.compomics.util.experiment.identification.identification_parameters.MsAmandaParameters;
import com.compomics.util.experiment.identification.identification_parameters.MsgfParameters;
import com.compomics.util.experiment.identification.identification_parameters.MyriMatchParameters;
import com.compomics.util.experiment.identification.identification_parameters.OmssaParameters;
import com.compomics.util.experiment.identification.identification_parameters.PNovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.PepnovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.XtandemParameters;
import com.compomics.util.experiment.identification.search_parameters_cli.IdentificationParametersCLIParams;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.preferences.ModificationProfile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class IdentificationParametersInputBean {
    private SearchParameters searchParameters;
    private File destinationFile;
    private Boolean listMods = false;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();

    public IdentificationParametersInputBean(CommandLine aLine) throws FileNotFoundException, IOException, ClassNotFoundException {
        Integer option;
        String arg;
        Number option2;
        String arg2;
        Integer option3;
        String arg3;
        Number option4;
        String arg4;
        Integer option5;
        String arg5;
        Number option6;
        String arg6;
        Integer option7;
        String arg7;
        Number option8;
        String arg8;
        Number option9;
        String arg9;
        PTM modification;
        ArrayList<String> args;
        String arg10;
        Serializable option10;
        String arg11;
        if (aLine.hasOption(IdentificationParametersCLIParams.MODS.id)) {
            this.listMods = true;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OUTPUT.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.OUTPUT.id);
            if (!arg11.endsWith(".parameters")) {
                arg11 = arg11 + ".parameters";
            }
            this.destinationFile = new File(arg11);
        }
        this.searchParameters = new SearchParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_PPM.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_PPM.id);
            option10 = new Integer(arg11);
            if ((Integer)option10 == 1) {
                this.searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
            } else {
                this.searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id);
            option10 = new Integer(arg11);
            if ((Integer)option10 == 1) {
                this.searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
            } else {
                this.searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_TOL.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_TOL.id);
            option10 = new Double(arg11);
            this.searchParameters.setPrecursorAccuracy((Double)option10);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_TOL.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_TOL.id);
            option10 = new Double(arg11);
            this.searchParameters.setFragmentIonAccuracy((Double)option10);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ENZYME.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.ENZYME.id);
            option10 = this.enzymeFactory.getEnzyme(arg11);
            this.searchParameters.setEnzyme((Enzyme)option10);
        } else {
            Enzyme option11 = this.enzymeFactory.getEnzyme("Trypsin");
            this.searchParameters.setEnzyme(option11);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DB.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.DB.id);
            File fastaFile = new File(arg11);
            this.searchParameters.setFastaFile(fastaFile);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MC.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.MC.id);
            option10 = new Integer(arg11);
            this.searchParameters.setnMissedCleavages((Integer)option10);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FI.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.FI.id);
            this.searchParameters.setIonSearched1(arg11);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.RI.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.RI.id);
            this.searchParameters.setIonSearched2(arg11);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MIN_CHARGE.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.MIN_CHARGE.id);
            option10 = new Integer(arg11);
            this.searchParameters.setMinChargeSearched(new Charge(1, (Integer)option10));
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MAX_CHARGE.id)) {
            arg11 = aLine.getOptionValue(IdentificationParametersCLIParams.MAX_CHARGE.id);
            option10 = new Integer(arg11);
            this.searchParameters.setMaxChargeSearched(new Charge(1, (Integer)option10));
        }
        ModificationProfile modificationProfile = new ModificationProfile();
        if (aLine.hasOption(IdentificationParametersCLIParams.FIXED_MODS.id)) {
            arg10 = aLine.getOptionValue(IdentificationParametersCLIParams.FIXED_MODS.id);
            args = CommandLineUtils.splitInput(arg10);
            for (String ptmName : args) {
                modification = this.ptmFactory.getPTM(ptmName);
                modificationProfile.addFixedModification(modification);
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.VARIABLE_MODS.id)) {
            arg10 = aLine.getOptionValue(IdentificationParametersCLIParams.VARIABLE_MODS.id);
            args = CommandLineUtils.splitInput(arg10);
            for (String ptmName : args) {
                modification = this.ptmFactory.getPTM(ptmName);
                modificationProfile.addVariableModification(modification);
            }
        }
        this.searchParameters.setModificationProfile(modificationProfile);
        OmssaParameters omssaParameters = new OmssaParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id);
            option9 = new Integer(arg9);
            omssaParameters.setRemovePrecursor((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id);
            option9 = new Integer(arg9);
            omssaParameters.setScalePrecursor((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id);
            option9 = new Integer(arg9);
            omssaParameters.setEstimateCharge((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id);
            option9 = new Double(arg9);
            omssaParameters.setMaxEValue((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id);
            option9 = new Integer(arg9);
            omssaParameters.setHitListLength((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id);
            option9 = new Integer(arg9);
            omssaParameters.setMinPeptideLength((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id);
            option9 = new Integer(arg9);
            omssaParameters.setMaxPeptideLength((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORMAT.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORMAT.id);
            option9 = new Integer(arg9);
            omssaParameters.setSelectedOutput(OmssaParameters.getOmssaOutputTypes()[(Integer)option9]);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id);
            option9 = new Integer(arg9);
            omssaParameters.setMemoryMappedSequenceLibraries((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ISOTOPES.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ISOTOPES.id);
            option9 = new Integer(arg9);
            omssaParameters.setNumberOfItotopicPeaks((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_NEUTRON.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_NEUTRON.id);
            option9 = new Double(arg9);
            omssaParameters.setNeutronThreshold((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id);
            option9 = new Double(arg9);
            omssaParameters.setLowIntensityCutOff((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id);
            option9 = new Double(arg9);
            omssaParameters.setHighIntensityCutOff((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id);
            option9 = new Double(arg9);
            omssaParameters.setIntensityCutOffIncrement((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id);
            option9 = new Integer(arg9);
            omssaParameters.setSingleChargeWindow((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id);
            option9 = new Integer(arg9);
            omssaParameters.setDoubleChargeWindow((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id);
            option9 = new Integer(arg9);
            omssaParameters.setnPeaksInSingleChargeWindow((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id);
            option9 = new Integer(arg9);
            omssaParameters.setnPeaksInDoubleChargeWindow((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id);
            option9 = new Integer(arg9);
            omssaParameters.setnAnnotatedMostIntensePeaks((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id);
            option9 = new Integer(arg9);
            omssaParameters.setMinAnnotatedPeaks((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id);
            option9 = new Integer(arg9);
            omssaParameters.setMinPeaks((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_METHIONINE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_METHIONINE.id);
            option9 = new Integer(arg9);
            omssaParameters.setCleaveNterMethionine((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id);
            option9 = new Integer(arg9);
            omssaParameters.setMaxMzLadders((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id);
            option9 = new Integer(arg9);
            omssaParameters.setMaxFragmentCharge((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id);
            option9 = new Double(arg9);
            omssaParameters.setFractionOfPeaksForChargeEstimation((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id);
            option9 = new Integer(arg9);
            omssaParameters.setDetermineChargePlusOneAlgorithmically((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id);
            option9 = new Integer(arg9);
            omssaParameters.setSearchPositiveIons((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id);
            option9 = new Integer(arg9);
            omssaParameters.setMinPrecPerSpectrum((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id);
            option9 = new Integer(arg9);
            omssaParameters.setSearchForwardFragmentFirst((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id);
            option9 = new Integer(arg9);
            omssaParameters.setSearchRewindFragments((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id);
            option9 = new Integer(arg9);
            omssaParameters.setMaxFragmentPerSeries((Integer)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id);
            option9 = new Integer(arg9);
            omssaParameters.setUseCorrelationCorrectionScore((Integer)option9 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id);
            option9 = new Double(arg9);
            omssaParameters.setConsecutiveIonProbability((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id);
            option9 = new Double(arg9);
            omssaParameters.setIterativeSequenceEvalue((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id);
            option9 = new Double(arg9);
            omssaParameters.setIterativeSpectrumEvalue((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id);
            option9 = new Double(arg9);
            omssaParameters.setIterativeReplaceEvalue((Double)option9);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id)) {
            arg9 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id);
            option9 = new Integer(arg9);
            omssaParameters.setMaxFragmentPerSeries((Integer)option9);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.omssa.getIndex(), omssaParameters);
        this.ptmFactory.setSearchedOMSSAIndexes(this.searchParameters.getModificationProfile());
        XtandemParameters xtandemParameters = new XtandemParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id);
            option8 = new Double(arg8);
            xtandemParameters.setDynamicRange((Double)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setnPeaks((Integer)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id);
            option8 = new Double(arg8);
            xtandemParameters.setMinFragmentMz((Double)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setMinPeaksPerSpectrum((Integer)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id);
            option8 = new Integer(arg8);
            xtandemParameters.setUseNoiseSuppression((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id);
            option8 = new Double(arg8);
            xtandemParameters.setMinPrecursorMass((Double)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id);
            option8 = new Integer(arg8);
            xtandemParameters.setProteinQuickAcetyl((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id);
            option8 = new Integer(arg8);
            xtandemParameters.setQuickPyrolidone((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setStpBias((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE.id);
            option8 = new Integer(arg8);
            xtandemParameters.setRefine((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id);
            option8 = new Double(arg8);
            xtandemParameters.setMaximumExpectationValueRefinement((Double)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id);
            option8 = new Integer(arg8);
            xtandemParameters.setRefineUnanticipatedCleavages((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id);
            option8 = new Integer(arg8);
            xtandemParameters.setRefineSemi((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id);
            option8 = new Integer(arg8);
            xtandemParameters.setPotentialModificationsForFullRefinment((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setRefinePointMutations((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setRefineSnaps((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setRefineSpectrumSynthesis((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_EVALUE.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_EVALUE.id);
            option8 = new Double(arg8);
            xtandemParameters.setMaxEValue((Double)option8);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id);
            option8 = new Integer(arg8);
            xtandemParameters.setOutputProteins((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id);
            option8 = new Integer(arg8);
            xtandemParameters.setOutputSequences((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id);
            option8 = new Integer(arg8);
            xtandemParameters.setOutputSpectra((Integer)option8 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_SKYLINE.id)) {
            arg8 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_SKYLINE.id);
            xtandemParameters.setSkylinePath(arg8);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), xtandemParameters);
        MsgfParameters msgfParameters = new MsgfParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_DECOY.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_DECOY.id);
            option7 = new Integer(arg7);
            msgfParameters.setSearchDecoyDatabase(option7 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id);
            Integer instrumentID = new Integer(arg7);
            msgfParameters.setInstrumentID(instrumentID);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id);
            option7 = new Integer(arg7);
            msgfParameters.setFragmentationType(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_PROTOCOL.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PROTOCOL.id);
            option7 = new Integer(arg7);
            msgfParameters.setProtocol(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id);
            option7 = new Integer(arg7);
            msgfParameters.setMinPeptideLength(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id);
            option7 = new Integer(arg7);
            msgfParameters.setMaxPeptideLength(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id);
            option7 = new Integer(arg7);
            msgfParameters.setNumberOfSpectrumMarches(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id);
            option7 = new Integer(arg7);
            msgfParameters.setAdditionalOutput(option7 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_ISOTOPE_LOW.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ISOTOPE_LOW.id);
            option7 = new Integer(arg7);
            msgfParameters.setLowerIsotopeErrorRange(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_ISOTOPE_HIGH.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ISOTOPE_HIGH.id);
            option7 = new Integer(arg7);
            msgfParameters.setUpperIsotopeErrorRange(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_TERMINI.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TERMINI.id);
            option7 = new Integer(arg7);
            msgfParameters.setNumberTolerableTermini(option7);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_PTMS.id)) {
            arg7 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PTMS.id);
            option7 = new Integer(arg7);
            msgfParameters.setNumberOfPtmsPerPeptide(option7);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), msgfParameters);
        MyriMatchParameters myriMatchParameters = new MyriMatchParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setMinPeptideLength((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setMaxPeptideLength((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id);
            option6 = new Double(arg6);
            myriMatchParameters.setMinPrecursorMass((Double)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id);
            option6 = new Double(arg6);
            myriMatchParameters.setMaxPrecursorMass((Double)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_ISOTOPE_LOW.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_ISOTOPE_LOW.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setLowerIsotopeCorrectionRange((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_ISOTOPE_HIGH.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_ISOTOPE_HIGH.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setUpperIsotopeCorrectionRange((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_MATCHES.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_MATCHES.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setNumberOfSpectrumMatches((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setMaxDynamicMods((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id);
            myriMatchParameters.setFragmentationRule(arg6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setMinTerminiCleavages((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setUseSmartPlusThreeModel((Integer)option6 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setComputeXCorr((Integer)option6 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id);
            option6 = new Double(arg6);
            myriMatchParameters.setTicCutoffPercentage((Double)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setNumIntensityClasses((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setClassSizeMultiplier((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setNumberOfBatches((Integer)option6);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id)) {
            arg6 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id);
            option6 = new Integer(arg6);
            myriMatchParameters.setMaxPeakCount((Integer)option6);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), myriMatchParameters);
        MsAmandaParameters msAmandaParameters = new MsAmandaParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id)) {
            arg5 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id);
            option5 = new Integer(arg5);
            msAmandaParameters.setGenerateDecoyDatabase(option5 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id)) {
            arg5 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id);
            msAmandaParameters.setInstrumentID(arg5);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id)) {
            arg5 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id);
            option5 = new Integer(arg5);
            msAmandaParameters.setMaxRank(option5);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id)) {
            arg5 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id);
            option5 = new Integer(arg5);
            msAmandaParameters.setMonoIsotopic(option5 == 1);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex(), msAmandaParameters);
        CometParameters cometParameters = new CometParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id);
            option4 = new Integer(arg4);
            cometParameters.setNumberOfSpectrumMatches((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_PTMS.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_PTMS.id);
            option4 = new Integer(arg4);
            cometParameters.setMaxVariableMods((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id);
            option4 = new Integer(arg4);
            cometParameters.setMinPeaks((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id);
            option4 = new Double(arg4);
            cometParameters.setMinPeakIntensity((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id);
            option4 = new Integer(arg4);
            cometParameters.setRemovePrecursor((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id);
            option4 = new Double(arg4);
            cometParameters.setRemovePrecursorTolerance((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id);
            option4 = new Double(arg4);
            cometParameters.setLowerClearMzRange((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id);
            option4 = new Double(arg4);
            cometParameters.setUpperClearMzRange((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id);
            option4 = new Integer(arg4);
            cometParameters.setEnzymeType((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id);
            option4 = new Integer(arg4);
            cometParameters.setIsotopeCorrection((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id);
            option4 = new Double(arg4);
            cometParameters.setMinPrecursorMass((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id);
            option4 = new Double(arg4);
            cometParameters.setMaxPrecursorMass((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id);
            option4 = new Integer(arg4);
            cometParameters.setMaxFragmentCharge((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_METH.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_METH.id);
            option4 = new Integer(arg4);
            cometParameters.setRemoveMethionine((Integer)option4 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id);
            option4 = new Integer(arg4);
            cometParameters.setBatchSize((Integer)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id);
            option4 = new Integer(arg4);
            cometParameters.setTheoreticalFragmentIonsSumOnly((Integer)option4 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id);
            option4 = new Double(arg4);
            cometParameters.setFragmentBinOffset((Double)option4);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_USE_SPARSE_MATRIX.id)) {
            arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_USE_SPARSE_MATRIX.id);
            option4 = new Integer(arg4);
            cometParameters.setUseSparseMatrix((Integer)option4 == 1);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), cometParameters);
        PepnovoParameters pepnovoParameters = new PepnovoParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id);
            option3 = new Integer(arg3);
            pepnovoParameters.setHitListLength(option3);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id);
            option3 = new Integer(arg3);
            pepnovoParameters.setEstimateCharge(option3 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id);
            option3 = new Integer(arg3);
            pepnovoParameters.setCorrectPrecursorMass(option3 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            option3 = new Integer(arg3);
            pepnovoParameters.setDiscardLowQualitySpectra(option3 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            option3 = new Integer(arg3);
            pepnovoParameters.setDiscardLowQualitySpectra(option3 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id);
            pepnovoParameters.setFragmentationModel(arg3);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id)) {
            arg3 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id);
            option3 = new Integer(arg3);
            pepnovoParameters.setGenerateQuery(option3 == 1);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex(), pepnovoParameters);
        DirecTagParameters direcTagParameters = new DirecTagParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id);
            option2 = new Integer(arg2);
            direcTagParameters.setTicCutoffPercentage(((Integer)option2).intValue());
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id);
            option2 = new Integer(arg2);
            direcTagParameters.setMaxPeakCount((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id);
            option2 = new Integer(arg2);
            direcTagParameters.setNumIntensityClasses((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id);
            option2 = new Integer(arg2);
            direcTagParameters.setAdjustPrecursorMass((Integer)option2 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECUSOR_ADJUSTMENT.id);
            option2 = new Double(arg2);
            direcTagParameters.setMinPrecursorAdjustment((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECUSOR_ADJUSTMENT.id);
            option2 = new Double(arg2);
            direcTagParameters.setMaxPrecursorAdjustment((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_PRECUSOR_ADJUSTMENT_STEP.id);
            option2 = new Double(arg2);
            direcTagParameters.setPrecursorAdjustmentStep((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id);
            option2 = new Integer(arg2);
            direcTagParameters.setNumChargeStates((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id);
            direcTagParameters.setOutputSuffix(arg2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id);
            option2 = new Integer(arg2);
            direcTagParameters.setUseChargeStateFromMS((Integer)option2 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id);
            option2 = new Integer(arg2);
            direcTagParameters.setDuplicateSpectra((Integer)option2 == 1);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id);
            option2 = new Integer(arg2);
            direcTagParameters.setDeisotopingMode((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id);
            option2 = new Double(arg2);
            direcTagParameters.setIsotopeMzTolerance((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id);
            option2 = new Double(arg2);
            direcTagParameters.setComplementMzTolerance((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id);
            option2 = new Integer(arg2);
            direcTagParameters.setTagLength((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id);
            option2 = new Integer(arg2);
            direcTagParameters.setMaxDynamicMods((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id);
            option2 = new Integer(arg2);
            direcTagParameters.setMaxTagCount((Integer)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id);
            option2 = new Double(arg2);
            direcTagParameters.setIntensityScoreWeight((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id);
            option2 = new Double(arg2);
            direcTagParameters.setMzFidelityScoreWeight((Double)option2);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id);
            option2 = new Double(arg2);
            direcTagParameters.setComplementScoreWeight((Double)option2);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.direcTag.getIndex(), direcTagParameters);
        PNovoParameters pNovoParameters = new PNovoParameters();
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id);
            option = new Integer(arg);
            pNovoParameters.setNumberOfPeptides(option);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id);
            option = new Integer(arg);
            pNovoParameters.setLowerPrecursorMass(option);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id);
            option = new Integer(arg);
            pNovoParameters.setUpperPrecursorMass(option);
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id);
            pNovoParameters.setActicationType(arg);
        }
        this.searchParameters.setIdentificationAlgorithmParameter(Advocate.pNovo.getIndex(), pNovoParameters);
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public Boolean isListMods() {
        return this.listMods;
    }

    public static boolean isValidModifications(CommandLine aLine) throws IOException {
        PTM ptm;
        ArrayList<String> args;
        String arg;
        boolean error = false;
        if (aLine.hasOption(IdentificationParametersCLIParams.FIXED_MODS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.FIXED_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    ptm = PTMFactory.getInstance().getPTM(ptmName);
                    if (ptm != null && ptm != PTMFactory.unknownPTM) continue;
                    throw new IllegalArgumentException("PTM " + ptmName + " not found.");
                }
            }
            catch (Exception e) {
                if (!error) {
                    System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the fixed modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                }
                e.printStackTrace();
                error = true;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.VARIABLE_MODS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.VARIABLE_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    ptm = PTMFactory.getInstance().getPTM(ptmName);
                    if (ptm != null) continue;
                    throw new IllegalArgumentException("PTM " + ptmName + " not found.");
                }
            }
            catch (Exception e) {
                if (!error) {
                    System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the variable modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                }
                e.printStackTrace();
                error = true;
            }
        }
        return !error;
    }

    public static boolean isValidStartup(CommandLine aLine) throws IOException {
        int value;
        String arg;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MODS.id)) {
            return true;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_PPM.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_PPM.id);
            try {
                value = new Integer(arg);
                if (value != 0 && value != 1) {
                    throw new IllegalArgumentException("Found " + value + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the ppm/Da precursor ion parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id);
            try {
                value = new Integer(arg);
                if (value != 0 && value != 1) {
                    throw new IllegalArgumentException("Found " + value + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the ppm/Da precursor ion parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_TOL.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_TOL.id);
            try {
                double value2 = new Double(arg);
                if (value2 <= 0.0) {
                    throw new IllegalArgumentException("Negative value for the precursor tolerance.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the precursor mass tolerance parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_TOL.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_TOL.id);
            try {
                double value3 = new Double(arg);
                if (value3 <= 0.0) {
                    throw new IllegalArgumentException("Negative value for the precursor tolerance.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the precursor mass tolerance parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ENZYME.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.ENZYME.id);
            Enzyme option = EnzymeFactory.getInstance().getEnzyme(arg);
            if (option == null) {
                System.out.println(System.getProperty("line.separator") + "Enzyme " + arg + " not recognized." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (!aLine.hasOption(IdentificationParametersCLIParams.DB.id) || aLine.getOptionValue(IdentificationParametersCLIParams.DB.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "No database specified" + System.getProperty("line.separator"));
            return false;
        }
        arg = aLine.getOptionValue(IdentificationParametersCLIParams.DB.id);
        File fastaFile = new File(arg);
        if (!fastaFile.exists()) {
            System.out.println(System.getProperty("line.separator") + "Database not found." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MC.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.MC.id);
            try {
                int value4 = new Integer(arg);
                if (value4 < 0) {
                    throw new IllegalArgumentException("Found negative value for the number of missed cleavages.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the number of missed cleavages:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MIN_CHARGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.MIN_CHARGE.id);
            try {
                int value5 = new Integer(arg);
                if (value5 < 0) {
                    throw new IllegalArgumentException("Found negative value for the minimal charge.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the minimal charge:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MAX_CHARGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.MAX_CHARGE.id);
            try {
                int value6 = new Integer(arg);
                if (value6 < 0) {
                    throw new IllegalArgumentException("Found negative value for the maximal charge.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the minimal charge:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id);
            try {
                int value7 = new Integer(arg);
                if (value7 != 0 && value7 != 1) {
                    throw new IllegalArgumentException("Found " + value7 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id);
            try {
                int value8 = new Integer(arg);
                if (value8 != 0 && value8 != 1) {
                    throw new IllegalArgumentException("Found " + value8 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id);
            try {
                int value9 = new Integer(arg);
                if (value9 != 0 && value9 != 1) {
                    throw new IllegalArgumentException("Found " + value9 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id);
            try {
                double value10 = new Double(arg);
                if (value10 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id);
            try {
                int value11 = new Integer(arg);
                if (value11 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id);
            try {
                int value12 = new Integer(arg);
                if (value12 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id);
            try {
                int value13 = new Integer(arg);
                if (value13 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id);
            try {
                int value14 = new Integer(arg);
                if (value14 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORMAT.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORMAT.id);
            try {
                int value15 = new Integer(arg);
                if (value15 != 0 && value15 != 1) {
                    throw new IllegalArgumentException("Found " + value15 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_FORMAT.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id);
            try {
                int value16 = new Integer(arg);
                if (value16 != 0 && value16 != 1) {
                    throw new IllegalArgumentException("Found " + value16 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ISOTOPES.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ISOTOPES.id);
            try {
                int value17 = new Integer(arg);
                if (value17 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_ISOTOPES.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_NEUTRON.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_NEUTRON.id);
            try {
                double value18 = new Double(arg);
                if (value18 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_NEUTRON.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id);
            try {
                double value19 = new Double(arg);
                if (value19 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id);
            try {
                double value20 = new Double(arg);
                if (value20 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id);
            try {
                double value21 = new Double(arg);
                if (value21 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id);
            try {
                int value22 = new Integer(arg);
                if (value22 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id);
            try {
                int value23 = new Integer(arg);
                if (value23 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id);
            try {
                int value24 = new Integer(arg);
                if (value24 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id);
            try {
                int value25 = new Integer(arg);
                if (value25 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id);
            try {
                int value26 = new Integer(arg);
                if (value26 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id);
            try {
                int value27 = new Integer(arg);
                if (value27 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id);
            try {
                int value28 = new Integer(arg);
                if (value28 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_METHIONINE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_METHIONINE.id);
            try {
                int value29 = new Integer(arg);
                if (value29 != 0 && value29 != 1) {
                    throw new IllegalArgumentException("Found " + value29 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_METHIONINE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id);
            try {
                int value30 = new Integer(arg);
                if (value30 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id);
            try {
                int value31 = new Integer(arg);
                if (value31 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id);
            try {
                double value32 = new Double(arg);
                if (value32 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id);
            try {
                int value33 = new Integer(arg);
                if (value33 != 0 && value33 != 1) {
                    throw new IllegalArgumentException("Found " + value33 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id);
            try {
                int value34 = new Integer(arg);
                if (value34 != 0 && value34 != 1) {
                    throw new IllegalArgumentException("Found " + value34 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id);
            try {
                double value35 = new Double(arg);
                if (value35 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id);
            try {
                int value36 = new Integer(arg);
                if (value36 != 0 && value36 != 1) {
                    throw new IllegalArgumentException("Found " + value36 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id);
            try {
                int value37 = new Integer(arg);
                if (value37 != 0 && value37 != 1) {
                    throw new IllegalArgumentException("Found " + value37 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id);
            try {
                int value38 = new Integer(arg);
                if (value38 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id);
            try {
                int value39 = new Integer(arg);
                if (value39 != 0 && value39 != 1) {
                    throw new IllegalArgumentException("Found " + value39 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id);
            try {
                double value40 = new Double(arg);
                if (value40 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id);
            try {
                double value41 = new Double(arg);
                if (value41 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id);
            try {
                double value42 = new Double(arg);
                if (value42 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id);
            try {
                double value43 = new Double(arg);
                if (value43 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id);
            try {
                double value44 = new Double(arg);
                if (value44 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id);
            try {
                int value45 = new Integer(arg);
                if (value45 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_NPEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id);
            try {
                double value46 = new Double(arg);
                if (value46 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id);
            try {
                int value47 = new Integer(arg);
                if (value47 <= 0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id);
            try {
                int value48 = new Integer(arg);
                if (value48 != 0 && value48 != 1) {
                    throw new IllegalArgumentException("Found " + value48 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id);
            try {
                double value49 = new Double(arg);
                if (value49 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id);
            try {
                int value50 = new Integer(arg);
                if (value50 != 0 && value50 != 1) {
                    throw new IllegalArgumentException("Found " + value50 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id);
            try {
                int value51 = new Integer(arg);
                if (value51 != 0 && value51 != 1) {
                    throw new IllegalArgumentException("Found " + value51 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id);
            try {
                int value52 = new Integer(arg);
                if (value52 != 0 && value52 != 1) {
                    throw new IllegalArgumentException("Found " + value52 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE.id);
            try {
                int value53 = new Integer(arg);
                if (value53 != 0 && value53 != 1) {
                    throw new IllegalArgumentException("Found " + value53 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id);
            try {
                double value54 = new Double(arg);
                if (value54 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id);
            try {
                int value55 = new Integer(arg);
                if (value55 != 0 && value55 != 1) {
                    throw new IllegalArgumentException("Found " + value55 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id);
            try {
                int value56 = new Integer(arg);
                if (value56 != 0 && value56 != 1) {
                    throw new IllegalArgumentException("Found " + value56 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id);
            try {
                int value57 = new Integer(arg);
                if (value57 != 0 && value57 != 1) {
                    throw new IllegalArgumentException("Found " + value57 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id);
            try {
                int value58 = new Integer(arg);
                if (value58 != 0 && value58 != 1) {
                    throw new IllegalArgumentException("Found " + value58 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id);
            try {
                int value59 = new Integer(arg);
                if (value59 != 0 && value59 != 1) {
                    throw new IllegalArgumentException("Found " + value59 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id);
            try {
                int value60 = new Integer(arg);
                if (value60 != 0 && value60 != 1) {
                    throw new IllegalArgumentException("Found " + value60 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_EVALUE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_EVALUE.id);
            try {
                double value61 = new Double(arg);
                if (value61 <= 0.0) {
                    throw new IllegalArgumentException("Negative or null value found.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_EVALUE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id);
            try {
                int value62 = new Integer(arg);
                if (value62 != 0 && value62 != 1) {
                    throw new IllegalArgumentException("Found " + value62 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id);
            try {
                int value63 = new Integer(arg);
                if (value63 != 0 && value63 != 1) {
                    throw new IllegalArgumentException("Found " + value63 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id);
            try {
                int value64 = new Integer(arg);
                if (value64 != 0 && value64 != 1) {
                    throw new IllegalArgumentException("Found " + value64 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id);
            try {
                int value65 = new Integer(arg);
                if (value65 <= 0 || value65 > 20) {
                    throw new IllegalArgumentException("Hitlist length should be between 1 and 20.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id);
            try {
                int value66 = new Integer(arg);
                if (value66 != 0 && value66 != 1) {
                    throw new IllegalArgumentException("Found " + value66 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.PEPTNOVO_ESTIMATE_CHARGE.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id);
            try {
                int value67 = new Integer(arg);
                if (value67 != 0 && value67 != 1) {
                    throw new IllegalArgumentException("Found " + value67 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            try {
                int value68 = new Integer(arg);
                if (value68 != 0 && value68 != 1) {
                    throw new IllegalArgumentException("Found " + value68 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            try {
                int value69 = new Integer(arg);
                if (value69 != 0 && value69 != 1) {
                    throw new IllegalArgumentException("Found " + value69 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id) && !(arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id)).equalsIgnoreCase("CID_IT_TRYP")) {
            System.out.println(System.getProperty("line.separator") + "Fragmentation model not supported." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id);
            try {
                int value70 = new Integer(arg);
                if (value70 != 0 && value70 != 1) {
                    throw new IllegalArgumentException("Found " + value70 + " where 0 or 1 was expected.");
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the " + IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id + " option." + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the ppm/Da fragment ion parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

