/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.FixedModification;
import de.proteinms.xtandemparser.xtandem.InputParams;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.VariableModification;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ModificationMap
implements Serializable {
    private HashMap<String, Modification> iFixedModificationMap;
    private HashMap<String, Modification> iVarModificationMap;
    private PeptideMap iPeptideMap;
    private InputParams iInputParams;

    public ModificationMap(HashMap aRawModMap, PeptideMap aPeptideMap, InputParams aInputParams, int aNumberOfSpectra) {
        this.iInputParams = aInputParams;
        this.buildModificationMaps(aRawModMap, aPeptideMap, aNumberOfSpectra);
        this.iPeptideMap = aPeptideMap;
    }

    private void buildModificationMaps(HashMap rawModMap, PeptideMap peptideMap, int numberOfSpectra) {
        this.iFixedModificationMap = new HashMap();
        this.iVarModificationMap = new HashMap();
        if (rawModMap != null) {
            for (int i = 1; i <= numberOfSpectra; ++i) {
                for (int j = 1; j <= peptideMap.getNumberOfPeptides(i); ++j) {
                    List<Domain> domainList = peptideMap.getPeptideByIndex(i, j).getDomains();
                    for (int d = 1; d <= domainList.size(); ++d) {
                        int m_counter = 1;
                        int m_counter_variable = 1;
                        int m_counter_fixed = 1;
                        String domainID = domainList.get(d - 1).getDomainKey();
                        int domainStart = domainList.get(d - 1).getDomainStart();
                        int domainEnd = domainList.get(d - 1).getDomainEnd();
                        String modKey = "_s" + i + "_p" + j + "_d" + d + "_m" + m_counter;
                        while (rawModMap.get("name" + modKey) != null) {
                            VariableModification varMod;
                            String modID;
                            String modName = rawModMap.get("name" + modKey).toString();
                            double modMass = Double.parseDouble(rawModMap.get("modified" + modKey).toString());
                            String modLocation = rawModMap.get("at" + modKey).toString();
                            String aminoAcidSubstituted = null;
                            String[] values = modName.split("@");
                            String modifiedResidue = values[1];
                            if (rawModMap.get("pm" + modKey) != null) {
                                aminoAcidSubstituted = rawModMap.get("pm" + modKey).toString();
                            }
                            if (this.isFixedModificationInput(modMass, modifiedResidue, new Integer(modLocation) == domainStart, new Integer(modLocation) == domainEnd)) {
                                modID = domainID + "_m" + m_counter_fixed;
                                FixedModification fixedMod = new FixedModification(modName, modMass, modLocation, m_counter_fixed, aminoAcidSubstituted != null, aminoAcidSubstituted);
                                this.iFixedModificationMap.put(modID, fixedMod);
                                ++m_counter_fixed;
                            } else if (this.isVariableModificationInput(modMass, modifiedResidue, new Integer(modLocation) == domainStart, new Integer(modLocation) == domainEnd)) {
                                modID = domainID + "_m" + m_counter_variable;
                                varMod = new VariableModification(modName, modMass, modLocation, m_counter_variable, aminoAcidSubstituted != null, aminoAcidSubstituted);
                                this.iVarModificationMap.put(modID, varMod);
                                ++m_counter_variable;
                            } else {
                                modID = domainID + "_m" + m_counter_variable;
                                varMod = new VariableModification(modName, modMass, modLocation, m_counter_variable, aminoAcidSubstituted != null, aminoAcidSubstituted);
                                this.iVarModificationMap.put(modID, varMod);
                                ++m_counter_variable;
                            }
                            modKey = "_s" + i + "_p" + j + "_d" + d + "_m" + ++m_counter;
                        }
                    }
                }
            }
        }
    }

    private boolean isFixedModificationInput(double aModMass, String aaModified, boolean nTerm, boolean cTerm) {
        BigDecimal modMass = new BigDecimal(aModMass);
        modMass = modMass.setScale(2, 4);
        String modificationMasses = this.iInputParams.getResidueModMass();
        if (modificationMasses != null) {
            StringTokenizer tokenizer = new StringTokenizer(modificationMasses, ",");
            while (tokenizer.hasMoreTokens()) {
                String[] tokens = tokenizer.nextToken().split("@");
                BigDecimal inputMass = new BigDecimal(new Double(tokens[0]));
                if (!modMass.equals(inputMass = inputMass.setScale(2, 4)) || !tokens[1].equalsIgnoreCase(aaModified) && (!tokens[1].equalsIgnoreCase("[") || !nTerm) && (!tokens[1].equalsIgnoreCase("]") || !cTerm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableModificationInput(double aModMass, String aaModified, boolean nTerm, boolean cTerm) {
        BigDecimal inputMass;
        String[] tokens;
        BigDecimal modMass = new BigDecimal(aModMass);
        modMass = modMass.setScale(3, 4);
        String modificationMasses = this.iInputParams.getResiduePotModMass();
        String refineModificationMasses = this.iInputParams.getRefineModMass();
        if (modificationMasses != null) {
            StringTokenizer tokenizer = new StringTokenizer(modificationMasses, ",");
            while (tokenizer.hasMoreTokens()) {
                tokens = tokenizer.nextToken().split("@");
                inputMass = new BigDecimal(new Double(tokens[0]));
                if (modMass.equals(inputMass = inputMass.setScale(3, 4)) && !tokens[1].equalsIgnoreCase(aaModified) && (!tokens[1].equalsIgnoreCase("[") || !nTerm) && tokens[1].equalsIgnoreCase("]") && !cTerm) continue;
            }
        }
        if (refineModificationMasses != null) {
            StringTokenizer tokenizer2 = new StringTokenizer(refineModificationMasses, ",");
            while (tokenizer2.hasMoreTokens()) {
                tokens = tokenizer2.nextToken().split("@");
                inputMass = new BigDecimal(new Double(tokens[0]));
                if (modMass.equals(inputMass = inputMass.setScale(2, 4)) && !tokens[1].equalsIgnoreCase(aaModified) && (!tokens[1].equalsIgnoreCase("[") || !nTerm) && tokens[1].equalsIgnoreCase("]") && !cTerm) continue;
            }
        }
        return false;
    }

    public ArrayList<Modification> getFixedModifications(String aDomainKey) {
        ArrayList<Modification> modificationList = new ArrayList<Modification>();
        if (this.iFixedModificationMap != null) {
            int modCount = 1;
            while (this.iFixedModificationMap.get(aDomainKey + "_m" + modCount) != null) {
                modificationList.add(this.iFixedModificationMap.get(aDomainKey + "_m" + modCount));
                ++modCount;
            }
        }
        return modificationList;
    }

    public ArrayList<Modification> getAllFixedModifications() {
        ArrayList<Modification> fixedModList = new ArrayList<Modification>();
        for (Map.Entry<String, Modification> e : this.iFixedModificationMap.entrySet()) {
            fixedModList.add(e.getValue());
        }
        return fixedModList;
    }

    public ArrayList<Modification> getAllVariableModifications() {
        ArrayList<Modification> varModList = new ArrayList<Modification>();
        for (Map.Entry<String, Modification> e : this.iVarModificationMap.entrySet()) {
            varModList.add(e.getValue());
        }
        return varModList;
    }

    public ArrayList<Modification> getVariableModifications(String aDomainKey) {
        ArrayList<Modification> modificationList = new ArrayList<Modification>();
        if (this.iVarModificationMap != null) {
            int modCount = 1;
            while (this.iVarModificationMap.get(aDomainKey + "_m" + modCount) != null) {
                modificationList.add(this.iVarModificationMap.get(aDomainKey + "_m" + modCount));
                ++modCount;
            }
        }
        return modificationList;
    }
}

