/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.styles;

import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.writers.ExcelWriter;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;

public class DefaultStyle
implements WorkbookStyle {
    private HSSFWorkbook workbook;
    private CellStyle mainTitle;
    private CellStyle standardHeader;
    private CellStyle standard;
    private HashMap<Integer, CellStyle> hierarchicalStyles = new HashMap();
    private HashMap<Integer, CellStyle> hierarchicalHeaders = new HashMap();
    private static final HashMap<HSSFWorkbook, DefaultStyle> styles = new HashMap();

    public static DefaultStyle getStyle(ExcelWriter excelWriter) {
        HSSFWorkbook workbook = excelWriter.getWorkbook();
        DefaultStyle result = styles.get(workbook);
        if (result == null) {
            result = new DefaultStyle(excelWriter);
            styles.put(workbook, result);
        }
        return result;
    }

    private DefaultStyle(ExcelWriter excelWriter) {
        this.workbook = excelWriter.getWorkbook();
        this.setCellStyles();
    }

    private void setCellStyles() {
        HSSFFont f = this.workbook.createFont();
        f.setFontHeightInPoints((short)20);
        this.mainTitle = this.workbook.createCellStyle();
        this.mainTitle.setFont((Font)f);
        f = this.workbook.createFont();
        f.setFontHeightInPoints((short)8);
        this.standard = this.workbook.createCellStyle();
        this.standard.setFont((Font)f);
        f = this.workbook.createFont();
        f.setFontHeightInPoints((short)8);
        this.standardHeader = this.workbook.createCellStyle();
        this.standardHeader.setFont((Font)f);
        this.standardHeader.setBorderBottom((short)1);
        this.standardHeader.setBorderTop((short)1);
        this.standardHeader.setBorderLeft((short)1);
        this.standardHeader.setBorderRight((short)1);
        this.standardHeader.setAlignment((short)2);
        this.standardHeader.setVerticalAlignment((short)1);
        this.standardHeader.setFillForegroundColor((short)44);
        this.standardHeader.setFillPattern((short)1);
        HSSFPalette palette = this.workbook.getCustomPalette();
        palette.setColorAtIndex((short)44, (byte)-56, (byte)-56, (byte)-6);
        this.hierarchicalHeaders.put(0, this.standardHeader);
        HSSFCellStyle subHeader = this.workbook.createCellStyle();
        subHeader.setFont((Font)f);
        subHeader.setBorderBottom((short)1);
        subHeader.setBorderTop((short)1);
        subHeader.setBorderLeft((short)1);
        subHeader.setBorderRight((short)1);
        subHeader.setAlignment((short)2);
        subHeader.setVerticalAlignment((short)1);
        subHeader.setFillForegroundColor((short)23);
        palette.setColorAtIndex((short)23, (byte)-36, (byte)-36, (byte)-6);
        subHeader.setFillPattern((short)1);
        this.hierarchicalHeaders.put(1, (CellStyle)subHeader);
        subHeader = this.workbook.createCellStyle();
        subHeader.setFont((Font)f);
        subHeader.setBorderBottom((short)1);
        subHeader.setBorderTop((short)1);
        subHeader.setBorderLeft((short)1);
        subHeader.setBorderRight((short)1);
        subHeader.setAlignment((short)2);
        subHeader.setVerticalAlignment((short)1);
        subHeader.setFillForegroundColor((short)55);
        palette.setColorAtIndex((short)55, (byte)-26, (byte)-26, (byte)-6);
        subHeader.setFillPattern((short)1);
        this.hierarchicalHeaders.put(2, (CellStyle)subHeader);
        subHeader = this.workbook.createCellStyle();
        subHeader.setFont((Font)f);
        subHeader.setBorderBottom((short)1);
        subHeader.setBorderTop((short)1);
        subHeader.setBorderLeft((short)1);
        subHeader.setBorderRight((short)1);
        subHeader.setAlignment((short)2);
        subHeader.setVerticalAlignment((short)1);
        subHeader.setFillForegroundColor((short)22);
        palette.setColorAtIndex((short)22, (byte)-16, (byte)-16, (byte)-6);
        subHeader.setFillPattern((short)1);
        for (int i = 3; i < 100; ++i) {
            this.hierarchicalHeaders.put(i, (CellStyle)subHeader);
        }
    }

    @Override
    public CellStyle getMainTitleStyle() {
        return this.mainTitle;
    }

    @Override
    public float getMainTitleRowHeight() {
        return 26.0f;
    }

    @Override
    public CellStyle getStandardStyle() {
        return this.standard;
    }

    @Override
    public CellStyle getStandardStyle(int hierarchicalDepth) {
        CellStyle cellStyle = this.hierarchicalStyles.get(hierarchicalDepth);
        if (cellStyle == null) {
            cellStyle = this.standard;
        }
        return cellStyle;
    }

    @Override
    public float getStandardHeight() {
        return 12.75f;
    }

    @Override
    public CellStyle getHeaderStyle() {
        return this.standardHeader;
    }

    @Override
    public CellStyle getHeaderStyle(int hierarchicalDepth) {
        CellStyle cellStyle = this.hierarchicalHeaders.get(hierarchicalDepth);
        if (cellStyle == null) {
            cellStyle = this.standardHeader;
        }
        return cellStyle;
    }

    @Override
    public float getHeaderHeight() {
        return 12.75f;
    }
}

