/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class Node
implements Serializable {
    static final long serialVersionUID = 8936868785405252371L;
    private int depth;
    private HashMap<String, ArrayList<Integer>> accessions = new HashMap();
    private HashMap<String, ArrayList<Integer>> termini = new HashMap();
    private HashMap<Character, Node> subtree = null;
    public static final int proteinBatchSize = 100;
    private boolean listening = true;

    public Node(int depth) {
        this.depth = depth;
    }

    public Node(int depth, HashMap<String, ArrayList<Integer>> accessions) {
        this.depth = depth;
        this.accessions = accessions;
    }

    public HashMap<String, HashMap<String, ArrayList<Integer>>> getProteinMapping(AminoAcidSequence query, String currentSequence, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException {
        HashMap<String, HashMap<String, ArrayList<Integer>>> result = new HashMap<String, HashMap<String, ArrayList<Integer>>>(1);
        if (this.depth == query.length()) {
            result.put(currentSequence, this.getAllMappings());
        } else if (this.accessions != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            HashMap<String, HashMap<String, ArrayList<Integer>>> indexes = new HashMap<String, HashMap<String, ArrayList<Integer>>>(1);
            for (String accession : this.accessions.keySet()) {
                Protein protein = sequenceFactory.getProtein(accession);
                indexes.put(accession, this.matchInProtein(protein, this.accessions.get(accession), query, sequenceMatchingPreferences));
            }
            for (String accession : indexes.keySet()) {
                HashMap accessionIndexes = (HashMap)indexes.get(accession);
                for (String tempSequence : accessionIndexes.keySet()) {
                    HashMap<String, ArrayList<Integer>> mapping = result.get(tempSequence);
                    if (mapping == null) {
                        mapping = new HashMap(1);
                        result.put(tempSequence, mapping);
                    }
                    mapping.put(accession, (ArrayList<Integer>)accessionIndexes.get(tempSequence));
                }
            }
        } else {
            for (char aa : this.getNextAminoAcids(query, sequenceMatchingPreferences)) {
                Node node = this.subtree.get(Character.valueOf(aa));
                if (node == null) continue;
                String newSequence = currentSequence + aa;
                double xShare = (double)Util.getOccurrence(newSequence, 'X') / (double)newSequence.length();
                if (sequenceMatchingPreferences.hasLimitX() && !(xShare <= sequenceMatchingPreferences.getLimitX())) continue;
                result.putAll(node.getProteinMapping(query, newSequence, sequenceMatchingPreferences));
            }
        }
        return result;
    }

    private HashSet<Character> getNextAminoAcids(AminoAcidSequence peptideSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        HashSet<Character> result = new HashSet<Character>();
        char aa = peptideSequence.charAt(this.depth);
        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
        if (sequenceMatchingPreferences.getSequenceMatchingType() == SequenceMatchingPreferences.MatchingType.string) {
            result.add(Character.valueOf(aa));
        } else {
            for (char aaChar : aminoAcid.getSubAminoAcids()) {
                result.add(Character.valueOf(aaChar));
            }
            for (char aaChar : aminoAcid.getCombinations()) {
                result.add(Character.valueOf(aaChar));
            }
            if (sequenceMatchingPreferences.getSequenceMatchingType() == SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) {
                Object object = aminoAcid.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance()).iterator();
                while (object.hasNext()) {
                    char aaChar = ((Character)object.next()).charValue();
                    result.add(Character.valueOf(aaChar));
                }
            }
            if (sequenceMatchingPreferences.hasMutationMatrix()) {
                HashSet<Character> mutatedResults = new HashSet<Character>(result);
                for (Character originalAa : result) {
                    HashSet<Character> mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(originalAa);
                    if (mutatedAas == null) continue;
                    for (Character mutatedAa : mutatedAas) {
                        result.add(mutatedAa);
                    }
                }
                result = mutatedResults;
            }
        }
        return result;
    }

    public boolean splitNode(int maxNodeSize, int maxDepth) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        if (this.accessions.size() > maxNodeSize && this.depth <= maxDepth) {
            this.subtree = new HashMap();
            for (String accession : this.accessions.keySet()) {
                HashMap<Character, ArrayList<Integer>> indexes = this.getAA(accession, this.accessions.get(accession), this.depth);
                if (indexes.isEmpty()) {
                    indexes = this.getAA(accession, this.accessions.get(accession), this.depth);
                }
                for (char aa : indexes.keySet()) {
                    if (!this.subtree.containsKey(Character.valueOf(aa))) {
                        this.subtree.put(Character.valueOf(aa), new Node(this.depth + 1));
                    }
                    Node node = this.subtree.get(Character.valueOf(aa));
                    node.addAccession(accession, indexes.get(Character.valueOf(aa)));
                }
            }
            this.accessions.clear();
            this.accessions = null;
            for (Node node : this.subtree.values()) {
                node.splitNode(maxNodeSize, maxDepth);
            }
            return true;
        }
        return false;
    }

    public void addAccession(String accession, ArrayList<Integer> indexes) {
        this.accessions.put(accession, indexes);
    }

    public long getSize() {
        if (this.accessions != null) {
            return this.accessions.size();
        }
        long result = 0L;
        for (Node node : this.subtree.values()) {
            result += node.getSize();
        }
        return result;
    }

    public HashMap<String, ArrayList<Integer>> getAccessions() {
        return this.accessions;
    }

    public HashMap<String, ArrayList<Integer>> getTermini() {
        return this.termini;
    }

    public HashMap<Character, Node> getSubtree() {
        return this.subtree;
    }

    public void clearAccessions() {
        this.accessions.clear();
    }

    public boolean isEmpty() {
        return this.subtree == null && this.accessions.isEmpty();
    }

    public int getDepth() {
        return this.depth;
    }

    public HashMap<String, ArrayList<Integer>> getAllMappings() throws IOException {
        if (this.accessions != null) {
            HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>(this.accessions.size());
            for (String accession : this.accessions.keySet()) {
                ArrayList indexes = new ArrayList(this.accessions.get(accession));
                result.put(accession, indexes);
            }
            return result;
        }
        HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>();
        for (Node node : this.subtree.values()) {
            HashMap<String, ArrayList<Integer>> subResult = node.getAllMappings();
            for (String accession : subResult.keySet()) {
                ArrayList<Integer> indexes = result.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList(subResult.get(accession));
                    result.put(accession, indexes);
                    continue;
                }
                indexes.addAll((Collection<Integer>)subResult.get(accession));
                Collections.sort(indexes);
                int previousIndex = -1;
                ArrayList<Integer> singleIndexes = new ArrayList<Integer>(indexes.size());
                for (int tempIndex : indexes) {
                    if (tempIndex == previousIndex) continue;
                    singleIndexes.add(tempIndex);
                    previousIndex = tempIndex;
                }
                result.put(accession, singleIndexes);
            }
        }
        for (String accession : this.termini.keySet()) {
            ArrayList<Integer> indexes = result.get(accession);
            if (indexes == null) {
                indexes = new ArrayList(1);
                result.put(accession, indexes);
            }
            for (Integer index : this.termini.get(accession)) {
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        return result;
    }

    private HashMap<String, ArrayList<Integer>> matchInProtein(Protein protein, ArrayList<Integer> seeds, AminoAcidSequence peptideSequence, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = protein.getSequence();
        HashMap<String, ArrayList<Integer>> results = new HashMap<String, ArrayList<Integer>>();
        int peptideLength = peptideSequence.length();
        for (int i = 0; i < seeds.size(); ++i) {
            String subSequence;
            int startIndex = seeds.get(i);
            int endIndex = startIndex + peptideLength;
            if (endIndex > proteinSequence.length() || !peptideSequence.matches(subSequence = proteinSequence.substring(startIndex, endIndex), sequenceMatchingPreferences)) continue;
            ArrayList<Integer> indexes = results.get(subSequence);
            if (indexes == null) {
                indexes = new ArrayList(1);
                results.put(subSequence, indexes);
            }
            indexes.add(startIndex);
        }
        return results;
    }

    private HashMap<Character, ArrayList<Integer>> getAA(String accession, ArrayList<Integer> seeds, int offset) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = SequenceFactory.getInstance().getProtein(accession).getSequence();
        HashMap<Character, ArrayList<Integer>> result = new HashMap<Character, ArrayList<Integer>>();
        for (int startIndex : seeds) {
            int tempIndex = startIndex + offset;
            if (tempIndex < proteinSequence.length()) {
                char aa = proteinSequence.charAt(tempIndex);
                ArrayList<Integer> indexes = result.get(Character.valueOf(aa));
                if (indexes == null) {
                    indexes = new ArrayList(0);
                    result.put(Character.valueOf(aa), indexes);
                }
                if (indexes.contains(startIndex)) continue;
                indexes.add(startIndex);
                continue;
            }
            if (tempIndex == proteinSequence.length()) {
                ArrayList<Integer> indexes = this.termini.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList(0);
                    this.termini.put(accession, indexes);
                }
                if (indexes.contains(startIndex)) continue;
                indexes.add(startIndex);
                continue;
            }
            throw new IllegalArgumentException("Attempting to index after the protein termini.");
        }
        return result;
    }

    public Node getSubNode(String sequence) {
        if (sequence.length() <= this.depth) {
            throw new IllegalArgumentException(sequence + " is not subnode of the node (depth=" + this.depth + ").");
        }
        char aa = sequence.charAt(this.depth);
        if (this.depth < sequence.length() - 1) {
            return this.subtree.get(Character.valueOf(aa)).getSubNode(sequence);
        }
        if (this.depth == sequence.length() - 1) {
            return this.subtree.get(Character.valueOf(aa));
        }
        throw new IllegalArgumentException("depth " + this.depth + " longer than sequence " + sequence + ".");
    }
}

