## ----Load libraries, message=FALSE, warning = FALSE----------------------
library(MultiDataSet)
library(MEALData)
library(minfiData)
library(GenomicRanges)

## ----New Multi-----------------------------------------------------------
multi <- createMultiDataSet()
multi

## ----Names empty Multi---------------------------------------------------
names(multi)
length(names(multi))

## ----add_eset 10---------------------------------------------------------
data(eset)
eset
multi2 <- add_eset(multi, eset, dataset.type = "expression")
multi2
multi

## ----add_eset 2----------------------------------------------------------
multi2 <- add_eset(multi2, eset, dataset.type = "expression", dataset.name = "new")
multi2

## ----add_eset add id to eset---------------------------------------------
eset2 <- eset
eset2$id <- 1:61
multi2 <- add_eset(multi, eset2, dataset.type = "expression")
multi2

## ----add_eset overwrite, error=TRUE--------------------------------------
eset2 <- eset[, 1:10]
multi2 <- add_eset(multi, eset, dataset.type = "expression", warnings = FALSE)
multi2
multi2 <- add_eset(multi2, eset2, dataset.type = "expression", warnings = FALSE, overwrite = FALSE)
multi2
multi2 <- add_eset(multi2, eset2, dataset.type = "expression", warnings = FALSE, overwrite = TRUE)
multi2

## ----add_eset GRanges----------------------------------------------------
multi2 <- add_eset(multi, eset, dataset.type = "expression", warnings = FALSE, GRanges = NA)
multi2

## ----add_rse overwrite---------------------------------------------------
data("MsetEx")
MsetEx2 <- MsetEx[1:100, ] ### Subset the original set to speed up
GRSet <- mapToGenome(ratioConvert(MsetEx2)) ## Convert MethylSet (eSet-derived) to GenomicRatioSet
GRSet
multi <- createMultiDataSet()
multi2 <- add_rse(multi, GRSet, dataset.type = "methylation", warnings = FALSE)
multi2

## ----add genexep error, error = TRUE-------------------------------------
multi <- createMultiDataSet()
multi2 <- add_genexp(multi, eset)
eset

## ----add genexep 0-------------------------------------------------------
fvarLabels(eset)[1] <- "chromosome"
multi <- createMultiDataSet()
multi2 <- add_genexp(multi, eset)
multi2

## ----add genexp----------------------------------------------------------
multi2 <- add_genexp(multi2, eset, dataset.name = "2")
multi2

## ----create snpset-------------------------------------------------------
data(snps)
SnpSet <- new("SnpSet", call = snps$genotypes)
fData(SnpSet) <- snps$map
SnpSet

## ----add snpset1, error = TRUE-------------------------------------------
multi2 <- add_snps(multi, SnpSet)

## ----snpset1 fData-------------------------------------------------------
head(fData(SnpSet))

## ----add snpset2---------------------------------------------------------
fData(SnpSet) <- fData(SnpSet)[, -1]
multi2 <- add_snps(multi, SnpSet)
multi2

## ----Subsetting intro----------------------------------------------------
mset <- prepareMethylationSet(betavals, pheno)
multi <- createMultiDataSet()
multi <- add_methy(multi, mset)
multi <- add_genexp(multi, eset)
multi <- add_eset(multi, eset, dataset.type = "test", GRanges = NA)
multi

## ----subset samples------------------------------------------------------
samples <- sampleNames(eset)[1:25]
multi[samples, ]

## ----subset common samples-----------------------------------------------
commonSamples(multi)
length(intersect(sampleNames(eset), sampleNames(mset)))

## ----subset tables-------------------------------------------------------
multi[, "expression"]
multi[, c("methylation", "test")]

## ----select tables-------------------------------------------------------
multi[["expression"]]
multi[, "expression", drop = TRUE]

## ----Genomic Ranges------------------------------------------------------
range <- GRanges("chr17:1-100000")
multi[, , range]

## ----Genomic Ranges 2----------------------------------------------------
range2 <- GRanges(c("chr17:1-100000", "chr17:1000000-2000000"))
multi[, , range2]

## ----combined------------------------------------------------------------
multi[samples, "expression", range]
multi[samples, "methylation", range, drop = TRUE]

## ----Advanced genes------------------------------------------------------
subset(multi, genes == "SLC35E2")

## ----Advanced genes 2----------------------------------------------------
subset(multi, genes %in% c("SLC35E2", "IPO13", "TRPV1"))
subset(multi, genes == "EEF1A1" | genes == "LPP")

## ----Advanced pheno------------------------------------------------------
subset(multi, , gender == "female")

## ----Combined advanced---------------------------------------------------
subset(multi, genes == "SLC35E2", gender == "female")

