## ---- echo=FALSE, warning=FALSE------------------------------------------
suppressPackageStartupMessages(library(MultiAssayExperiment))

## ---- eval=FALSE---------------------------------------------------------
#  API()

## ---- eval=FALSE---------------------------------------------------------
#  API(shiny=TRUE)

## ------------------------------------------------------------------------
empty <- MultiAssayExperiment()
empty
slotNames(empty)

## ------------------------------------------------------------------------
class(experiments(empty)) # ExperimentList

## ------------------------------------------------------------------------
patient.data <- data.frame(sex=c("M", "F", "M", "F"),
    age=38:41,
    row.names=c("Jack", "Jill", "Bob", "Barbara"))
patient.data

## ------------------------------------------------------------------------
class(sampleMap(empty)) # DataFrame

## ------------------------------------------------------------------------
exprss1 <- matrix(rnorm(16), ncol = 4,
        dimnames = list(sprintf("ENST00000%i", sample(288754:290000, 4)),
                c("Jack", "Jill", "Bob", "Bobby")))
exprss2 <- matrix(rnorm(12), ncol = 3,
        dimnames = list(sprintf("ENST00000%i", sample(288754:290000, 4)),
                c("Jack", "Jane", "Bob")))
doubleExp <- list("methyl 2k"  = exprss1, "methyl 3k" = exprss2)
simpleMultiAssay <- MultiAssayExperiment(experiments=doubleExp)
simpleMultiAssay

## ------------------------------------------------------------------------
pData(simpleMultiAssay)

## ------------------------------------------------------------------------
simpleMultiAssay2 <- MultiAssayExperiment(experiments=doubleExp,
                                          pData=patient.data)
simpleMultiAssay2
pData(simpleMultiAssay2)

## ------------------------------------------------------------------------
class(metadata(empty)) # NULL (class "ANY")

## ---- message=FALSE------------------------------------------------------
library(Biobase)
(arraydat <- matrix(seq(101, 108), ncol=4,
                    dimnames=list(c("ENST00000294241", "ENST00000355076"),
                                  c("array1", "array2", "array3", "array4"))))
arraypdat <- as(data.frame(slope53=rnorm(4),
                           row.names=c("array1", "array2", "array3",
                                       "array4")), "AnnotatedDataFrame")
exprdat <- ExpressionSet(assayData=arraydat, phenoData=arraypdat)
exprdat

## ------------------------------------------------------------------------
(exprmap <- data.frame(primary=rownames(patient.data)[c(1, 2, 4, 3)],
                       assay=c("array1", "array2", "array3", "array4"),
                       stringsAsFactors = FALSE))

## ------------------------------------------------------------------------
(methyldat <-
   matrix(1:10, ncol=5,
          dimnames=list(c("ENST00000355076", "ENST00000383706"),
                        c("methyl1", "methyl2", "methyl3",
                          "methyl4", "methyl5"))))

## ------------------------------------------------------------------------
(methylmap <- data.frame(primary = c("Jack", "Jack", "Jill", "Barbara", "Bob"),
              assay = c("methyl1", "methyl2", "methyl3", "methyl4", "methyl5"),
              stringsAsFactors = FALSE))

## ------------------------------------------------------------------------
(microdat <- matrix(201:212, ncol=3,
                    dimnames=list(c("hsa-miR-21", "hsa-miR-191",
                                    "hsa-miR-148a", "hsa-miR148b"),
                                  c("micro1", "micro2", "micro3"))))

## ------------------------------------------------------------------------
(micromap <- data.frame(primary = c("Jack", "Barbara", "Bob"),
                        assay = c("micro1", "micro2", "micro3"),
                        stringsAsFactors = FALSE))

## ------------------------------------------------------------------------
suppressPackageStartupMessages(library(GenomicRanges))
## completely encompasses ENST00000355076
gr1 <-
  GRanges(seqnames = "chr3", ranges = IRanges(58000000, 59502360),
          strand = "+", score = 5L, GC = 0.45)
## first is within ENST0000035076
gr2 <-
  GRanges(seqnames = c("chr3", "chr3"),
          ranges = IRanges(c(58493000, 3), width=9000),
          strand = c("+", "-"), score = 3:4, GC = c(0.3, 0.5))
gr3 <-
  GRanges(seqnames = c("chr1", "chr2"),
          ranges = IRanges(c(1, 4), c(3, 9)),
          strand = c("-", "-"), score = c(6L, 2L), GC = c(0.4, 0.1))
grl <- GRangesList("gr1" = gr1, "gr2" = gr2, "gr3" = gr3)
names(grl) <- c("snparray1", "snparray2", "snparray3")
grl

## ------------------------------------------------------------------------
(rangemap <- data.frame(primary = c("Jack", "Jill", "Jill"),
                        assay = c("snparray1", "snparray2", "snparray3"),
                        stringsAsFactors = FALSE))

## ------------------------------------------------------------------------
library(SummarizedExperiment)
nrows <- 5; ncols <- 4
counts <- matrix(runif(nrows * ncols, 1, 1e4), nrows)
rowRanges <- GRanges(rep(c("chr1", "chr2"), c(2, nrows - 2)),
                     IRanges(floor(runif(nrows, 1e5, 1e6)), width=100),
                     strand=sample(c("+", "-"), nrows, TRUE),
                     feature_id=sprintf("ID\\%03d", 1:nrows))
names(rowRanges) <- letters[1:5]
colData <- DataFrame(Treatment=rep(c("ChIP", "Input"), 2),
                     row.names= c("mysnparray1", "mysnparray2",
                                  "mysnparray3", "mysnparray4"))
rse <- SummarizedExperiment(assays=SimpleList(counts=counts),
                            rowRanges=rowRanges, colData=colData)

## ------------------------------------------------------------------------
(rangemap2 <-
   data.frame(primary = c("Jack", "Jill", "Bob", "Barbara"),
              assay = c("mysnparray1", "mysnparray2", "mysnparray3",
                        "mysnparray4"), stringsAsFactors = FALSE))

## ------------------------------------------------------------------------
listmap <- list(exprmap, methylmap, micromap, rangemap, rangemap2)
names(listmap) <- c("Affy", "Methyl 450k", "Mirna", "CNV gistic", "CNV gistic2")
listmap

## ------------------------------------------------------------------------
dfmap <- listToMap(listmap)
dfmap

## ---- eval=FALSE---------------------------------------------------------
#  mapToList(dfmap, "assay")

## ------------------------------------------------------------------------
objlist <- list("Affy" = exprdat, "Methyl 450k" = methyldat,
                "Mirna" = microdat, "CNV gistic" = grl, "CNV gistic2" = rse)

## ------------------------------------------------------------------------
myMultiAssay <- MultiAssayExperiment(objlist, patient.data, dfmap)
myMultiAssay

## ------------------------------------------------------------------------
experiments(myMultiAssay)
pData(myMultiAssay)
sampleMap(myMultiAssay)
metadata(myMultiAssay)

## ------------------------------------------------------------------------
objlist3 <- objlist
(names(objlist3) <- NULL)
try(PrepMultiAssay(objlist3, patient.data, dfmap)$ExperimentList)

## ------------------------------------------------------------------------
names(objlist3) <- toupper(names(objlist))
names(objlist3)
unique(dfmap[, "assay"])
PrepMultiAssay(objlist3, patient.data, dfmap)$ExperimentList

## ------------------------------------------------------------------------
exampleMap <- sampleMap(simpleMultiAssay2)
sapply(doubleExp, colnames)
exampleMap
PrepMultiAssay(doubleExp, patient.data, exampleMap)$drops

## ------------------------------------------------------------------------
exMap <- rbind(dfmap,
               DataFrame(assay = "New methyl",
                         primary = "Joe",
                         colname = "Joe"))
PrepMultiAssay(objlist, patient.data, exMap)$drops

## ------------------------------------------------------------------------
prepped <- PrepMultiAssay(objlist, patient.data, exMap)
preppedMulti <- MultiAssayExperiment(prepped$ExperimentList, prepped$pData,
                                     prepped$sampleMap)
preppedMulti

## ------------------------------------------------------------------------
library(GenomicRanges)
grldf <- structure(
    list(chr = structure(c(1L, 1L, 1L, 1L, 1L),
                         class = "factor", .Label = "chr1"), 
         start = 11:15, end = 12:16,
         strand = structure(c(4L, 1L, 4L, 3L, 2L),
                            .Label = c("-", ".", "*", "+"),
                            class = "factor"), 
         score = 1:5, specimen =
             structure(c(1L, 1L, 2L, 2L, 3L),
                       .Label = c("a", "b", "c"),
                       class = "factor"),
         gene_symbols = structure(1:5, .Label = c("GENEa", "GENEb",
                                                  "GENEc", "GENEd",
                                                  "GENEe"),
                                  class = "factor")),
    .Names = c("chr", "start", "end", "strand", "score", "specimen",
               "gene_symbols"),
    row.names = c(NA, -5L), class = "data.frame")
makeGRangesListFromDataFrame(grldf, split.field = "specimen",
                             names.field = "gene_symbols")

## ------------------------------------------------------------------------
library(SummarizedExperiment)
sedf <- structure(list(chr = structure(c(1L, 1L, 1L, 1L, 1L),
                                        class = "factor", .Label = "chr2"), 
                        start = 11:15, end = 12:16,
                        strand = structure(c(4L, 1L, 4L, 3L, 2L),
                                           .Label = c("-", ".", "*", "+"),
                                           class = "factor"), 
                        expr0 = 3:7, expr1 = 8:12, expr2 = 12:16),
                   .Names = c("chr", "start", "end", "strand",
                              "expr0", "expr1", "expr2"),
                   row.names = c("GENEe", "GENEd", "GENEc", "GENEb", "GENEa"),
                   class = "data.frame")
sedf
makeSummarizedExperimentFromDataFrame(sedf)

## ------------------------------------------------------------------------
methods(class="RangedRaggedAssay")
getMethod("dimnames", "RangedRaggedAssay")

## ------------------------------------------------------------------------
class(experiments(myMultiAssay)[[4]])
rownames(experiments(myMultiAssay)[[4]])
colnames(experiments(myMultiAssay)[[4]])

## ------------------------------------------------------------------------
assay(experiments(myMultiAssay)[[4]], background = 2)

## ------------------------------------------------------------------------
rra <- experiments(myMultiAssay)[[4]]
mcols(rra[[1]])
assay(rra, background = 2)

## ------------------------------------------------------------------------
pData(myMultiAssay)

## ------------------------------------------------------------------------
subsetByColumn(myMultiAssay, 1:2)

## ------------------------------------------------------------------------
subsetByColumn(myMultiAssay, c("Jack", "Jill"))

## ------------------------------------------------------------------------
malesMultiAssay <- subsetByColumn(myMultiAssay, myMultiAssay$sex == "M")
pData(malesMultiAssay)

## ------------------------------------------------------------------------
myMultiAssay[, myMultiAssay$sex == "M", ]

## ------------------------------------------------------------------------
allsamples <- colnames(myMultiAssay)
allsamples

## ------------------------------------------------------------------------
allsamples[["Methyl 450k"]] <- allsamples[["Methyl 450k"]][-3:-5]
myMultiAssay[, as.list(allsamples), ]

## ------------------------------------------------------------------------
subsetByAssay(myMultiAssay, c("Affy", "CNV gistic"))

## ------------------------------------------------------------------------
is.cnv = grepl("CNV", names(experiments(myMultiAssay)))
is.cnv
subsetByAssay(myMultiAssay, is.cnv)
subsetByAssay(myMultiAssay, which(is.cnv))

## ------------------------------------------------------------------------
featSubsetted0 <- subsetByRow(myMultiAssay, "ENST00000355076")
class(featSubsetted0)
class(experiments(featSubsetted0))
experiments(featSubsetted0)

## ------------------------------------------------------------------------
featSubsetted <-
  subsetByRow(myMultiAssay, c("ENST00000355076", "ENST00000294241"))
exprs(experiments(myMultiAssay)[[1]])
exprs(experiments(featSubsetted)[[1]])

## ------------------------------------------------------------------------
gr <- GRanges(seqnames = c("chr1"), strand = c("-", "+", "-"),
              ranges = IRanges(start = c(1, 4, 6), width = 3))

## ------------------------------------------------------------------------
subsetted <- subsetByRow(myMultiAssay, gr, maxgap = 2L, type = "within")
experiments(subsetted)

## ---- eval=FALSE---------------------------------------------------------
#  myMultiAssay[rows, columns, assays]

## ------------------------------------------------------------------------
myMultiAssay["ENST00000355076", , ]

## ------------------------------------------------------------------------
myMultiAssay["ENST00000355076", 1:2, c("Affy", "Methyl 450k")]

## ------------------------------------------------------------------------
myMultiAssay[, "Jack", ]
myMultiAssay[, 1, ]
myMultiAssay[, c(TRUE, FALSE, FALSE, FALSE), ]

## ------------------------------------------------------------------------
myMultiAssay[, , "Mirna"]
myMultiAssay[, , 3]
myMultiAssay[, , c(FALSE, FALSE, TRUE, FALSE, FALSE)]

## ------------------------------------------------------------------------
myMultiAssay["ENST00000355076", , , drop=FALSE]

## ------------------------------------------------------------------------
myMultiAssay["ENST00000355076", , , drop=TRUE]

## ------------------------------------------------------------------------
rownames(myMultiAssay)
colnames(myMultiAssay)

## ------------------------------------------------------------------------
objlist2 <- objlist
objlist2[[2]] <- as.vector(objlist2[[2]])
invalid.obj <- try(MultiAssayExperiment(objlist2, patient.data, dfmap))
invalid.obj

## ------------------------------------------------------------------------
methods(class="MultiAssayExperiment")

## ------------------------------------------------------------------------
sessionInfo()

