## ---- echo=FALSE, warning=FALSE------------------------------------------
suppressPackageStartupMessages(library(MultiAssayExperiment))
suppressPackageStartupMessages(library(HDF5Array))

## ------------------------------------------------------------------------
smallMatrix <- matrix(rnorm(10e5), ncol = 20)

## ------------------------------------------------------------------------
rownames(smallMatrix) <- paste0("GENE", seq_len(nrow(smallMatrix)))
colnames(smallMatrix) <- paste0("SampleID", seq_len(ncol(smallMatrix)))

## ------------------------------------------------------------------------
smallMatrix <- DelayedArray(smallMatrix)
class(smallMatrix)
head(smallMatrix)
dim(smallMatrix)

## ------------------------------------------------------------------------
dataLocation <- system.file("extdata", "exMatrix.h5", package =
                              "MultiAssayExperiment", mustWork = TRUE)
hdf5Data <- HDF5Dataset(file = dataLocation, name = "exMatrix")
newDelayedMatrix <- DelayedArray(hdf5Data)
class(newDelayedMatrix)
head(newDelayedMatrix)

## ------------------------------------------------------------------------
HDF5MAE <- MultiAssayExperiment(experiments = list(smallMatrix = smallMatrix))
sampleMap(HDF5MAE)
pData(HDF5MAE)

## ------------------------------------------------------------------------
HDF5SE <- SummarizedExperiment(assays = smallMatrix)
assay(HDF5SE)
MultiAssayExperiment(list(HDF5SE = HDF5SE))

