## ----style-Sweave, eval=TRUE, echo=FALSE, results='asis'--------------------------------
BiocStyle::latex()

## ----include=FALSE----------------------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance=TRUE
)

## ---------------------------------------------------------------------------------------
library(MODA)
data(synthetic)
ResultFolder = 'ForSynthetic' # where middle files are stored
CuttingCriterion = 'Density' # could be Density or Modularity
indicator1 = 'X'     # indicator for data profile 1
indicator2 = 'Y'      # indicator for data profile 2
specificTheta = 0.1 #threshold to define condition specific modules
conservedTheta = 0.1#threshold to define conserved modules
##modules detection for network 1
intModules1 <- WeightedModulePartitionDensity(datExpr1,ResultFolder,
                                indicator1,CuttingCriterion)
##modules detection for network 2
intModules2 <- WeightedModulePartitionDensity(datExpr2,ResultFolder,
                                indicator2,CuttingCriterion)

## ----echo=FALSE,out.width='0.6\\textwidth'----------------------------------------------
heatmap(cor(as.matrix(datExpr1)))

## ---------------------------------------------------------------------------------------
CompareAllNets(ResultFolder,intModules1,indicator1,intModules2,
               indicator2,specificTheta,conservedTheta)

## ----sessionInfo, results='asis', echo=FALSE--------------------------------------------
toLatex(sessionInfo())

