### R code from vignette source 'IVAS.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex(use.unsrturl=FALSE)


###################################################
### code chunk number 2: loading IVAS package
###################################################
library(IVAS)


###################################################
### code chunk number 3: loading the expression data
###################################################
data(sampleexp)


###################################################
### code chunk number 4: loading the SNP data
###################################################
data(samplesnp)


###################################################
### code chunk number 5: loading the SNP position data
###################################################
data(samplesnplocus)


###################################################
### code chunk number 6: loading the txdb data
###################################################
sampleDB <- system.file("extdata", "sampleDB", package="IVAS")
sample.Txdb <- loadDb(sampleDB)


###################################################
### code chunk number 7: chrseparate function
###################################################
filtered.txdb <- chrseparate(sample.Txdb,19)
filtered.txdb


###################################################
### code chunk number 8: findAlternative function
###################################################
trans.exon.range <- exonsBy(filtered.txdb,by="tx")
trans.intron.range <- intronsByTranscript(filtered.txdb)
txTable <- select(filtered.txdb, keys=names(trans.exon.range),
                  columns=c("TXID","TXNAME","GENEID","TXSTART","TXEND"),keytype="TXID")
Altvalue <- findAlternative("ENSG00000170889",txTable,trans.exon.range,
                            trans.intron.range,19)
Altvalue


###################################################
### code chunk number 9: overlapsnp function
###################################################
ch.snp.locus <- as.matrix(samplesnplocus[samplesnplocus[,2] == 19,])
ch.snps <- matrix(ch.snp.locus[is.element(ch.snp.locus[,1],rownames(samplesnp)),],
                  ncol=3,byrow=FALSE)
ch.snps.range <- GRanges(seqnames=Rle(19),ranges=IRanges(start=as.integer(ch.snps[,3]),
                         end=as.integer(ch.snps[,3])),metadata=ch.snps[,1])
overlapsnp <- findOversnp(Altvalue,ch.snps.range)
overlapsnp


###################################################
### code chunk number 10: sqtlfinder function
###################################################
sqtl.result <- sqtlfinder(Altvalue,overlapsnp,sampleexp,samplesnp,"lm")
sqtl.result


###################################################
### code chunk number 11: MsqtlFinder function (eval = FALSE)
###################################################
## final.result <- MsqtlFinder(sampleexp,samplesnp,samplesnplocus,sample.Txdb,"lm",1)


###################################################
### code chunk number 12: saveBplot function
###################################################
saveBplot(sqtl.result,sampleexp,samplesnp,samplesnplocus,filtered.txdb,"./result")


###################################################
### code chunk number 13: sessionInfo
###################################################
sessionInfo()


