/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.HashMap;
import java.util.Set;
import org.cytoscape.equations.EqnCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Equation {
    private final String equation;
    private final Set<String> attribReferences;
    private final Object[] code;
    private final int[] sourceLocations;
    private final Class type;

    Equation(String equation, Set<String> attribReferences, Object[] code, int[] sourceLocations, Class type) {
        this.equation = equation;
        this.attribReferences = attribReferences;
        this.code = code;
        this.sourceLocations = sourceLocations;
        this.type = type;
    }

    public String toString() {
        return this.equation;
    }

    public boolean equals(Object other) {
        if (other.getClass() != Equation.class) {
            return false;
        }
        Equation otherEquation = (Equation)other;
        return this.equation.equals(otherEquation.equation);
    }

    public Set<String> getAttribReferences() {
        return this.attribReferences;
    }

    public Object[] getCode() {
        return this.code;
    }

    public int[] getSourceLocations() {
        return this.sourceLocations;
    }

    public Class getType() {
        return this.type;
    }

    public static Equation getErrorEquation(String equation, Class type, String errorMessage) {
        EqnCompiler compiler = new EqnCompiler();
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        if (!compiler.compile("=ERROR(\"" + Equation.escapeQuotes(errorMessage) + "\")", attribNameToTypeMap)) {
            throw new IllegalStateException("internal error in Equation.getErrorEquation().  This should *never* happen!");
        }
        Equation errorEquation = compiler.getEquation();
        return new Equation(equation, errorEquation.attribReferences, errorEquation.code, errorEquation.sourceLocations, type);
    }

    private static String escapeQuotes(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                builder.append('\\');
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

