/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.ArrowIcon;
import giny.view.EdgeView;
import java.awt.Color;
import javax.swing.Icon;

public class EdgeSourceArrowColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_SRCARROW_COLOR;
    }

    public Icon getIcon(Object value) {
        ArrowShape arrow = (ArrowShape)((Object)VisualPropertyType.EDGE_SRCARROW_SHAPE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()));
        ArrowIcon icon = new ArrowIcon(arrow);
        icon.setColor((Color)value);
        icon.setLeftPadding(20);
        icon.setBottomPadding(-6);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o, VisualPropertyDependency dep) {
        if (o == null || ev == null) {
            return;
        }
        if (dep != null && dep.check(VisualPropertyDependency.Definition.ARROW_COLOR_MATCHES_EDGE)) {
            if (ev.getUnselectedPaint() != ev.getSourceEdgeEndPaint()) {
                ev.setSourceEdgeEndPaint(ev.getUnselectedPaint());
            }
        } else {
            Color newSourceArrowColor = (Color)o;
            if (newSourceArrowColor != ev.getSourceEdgeEndPaint()) {
                ev.setSourceEdgeEndPaint(newSourceArrowColor);
            }
        }
    }

    public Object getDefaultAppearanceObject() {
        return Color.black;
    }

    public boolean constrained(VisualPropertyDependency dep) {
        return dep != null && dep.check(VisualPropertyDependency.Definition.ARROW_COLOR_MATCHES_EDGE);
    }
}

