/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr.test;

import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.MinIntHeap;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

public class BitSetPerformance {
    static BitSet _THE_BIT_ARRAY_ = null;
    static MinIntHeap _THE_HEAP_ = null;

    public static void main(String[] args) throws Exception {
        int read;
        int N = Integer.parseInt(args[0]);
        boolean repeat = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("repeat")) {
            repeat = true;
        }
        int[] elements = new int[N];
        InputStream in = System.in;
        byte[] buff = new byte[4];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            elements[inx++] = (Integer.MAX_VALUE & BitSetPerformance.assembleInt(buff)) % N;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        in = null;
        buff = null;
        BitSetPerformance._THE_TEST_CASE_(new int[]{0, 3, 4, 3, 9, 9, 1});
        Thread.sleep(1000L);
        for (int i = 0; i < 100; ++i) {
            int foo = i * 4 / 8;
        }
        long millisBegin = System.currentTimeMillis();
        int[] uniqueElements = BitSetPerformance._THE_TEST_CASE_(elements);
        long millisEnd = System.currentTimeMillis();
        if (!repeat) {
            System.err.println(millisEnd - millisBegin);
        }
        IntEnumerator sortedElements = _THE_HEAP_.orderedElements(false);
        if (!repeat) {
            while (sortedElements.numRemaining() > 0) {
                System.out.println(sortedElements.nextInt());
            }
        }
        if (repeat) {
            for (int i = 0; i < uniqueElements.length; ++i) {
                uniqueElements[i] = 0;
            }
            millisBegin = System.currentTimeMillis();
            BitSetPerformance._REPEAT_TEST_CASE_(elements, uniqueElements);
            millisEnd = System.currentTimeMillis();
            System.err.println(millisEnd - millisBegin + " (repeated test)");
            _THE_HEAP_.empty();
            _THE_HEAP_.toss(uniqueElements, 0, uniqueElements.length);
            while (_THE_HEAP_.size() > 0) {
                System.out.println(_THE_HEAP_.deleteMin());
            }
        }
    }

    private static final int assembleInt(byte[] fourConsecutiveBytes) {
        int firstByte = (fourConsecutiveBytes[0] & 0xFF) << 24;
        int secondByte = (fourConsecutiveBytes[1] & 0xFF) << 16;
        int thirdByte = (fourConsecutiveBytes[2] & 0xFF) << 8;
        int fourthByte = (fourConsecutiveBytes[3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }

    private static final int[] _THE_TEST_CASE_(int[] elements) {
        _THE_BIT_ARRAY_ = new BitSet(elements.length);
        _THE_HEAP_ = new MinIntHeap();
        for (int i = 0; i < elements.length; ++i) {
            if (_THE_BIT_ARRAY_.get(elements[i])) continue;
            _THE_HEAP_.toss(elements[i]);
            _THE_BIT_ARRAY_.set(elements[i]);
        }
        IntEnumerator iter = _THE_HEAP_.elements();
        int[] returnThis = new int[iter.numRemaining()];
        int numElements = returnThis.length;
        for (int i = 0; i < numElements; ++i) {
            returnThis[i] = iter.nextInt();
        }
        return returnThis;
    }

    private static final void _REPEAT_TEST_CASE_(int[] elements, int[] output) {
        _THE_HEAP_.empty();
        _THE_BIT_ARRAY_.clear(0, elements.length);
        for (int i = 0; i < elements.length; ++i) {
            if (_THE_BIT_ARRAY_.get(elements[i])) continue;
            _THE_HEAP_.toss(elements[i]);
            _THE_BIT_ARRAY_.set(elements[i]);
        }
        if (_THE_HEAP_.size() != output.length) {
            throw new IllegalStateException("output array is incorrect size");
        }
        IntEnumerator iter = _THE_HEAP_.elements();
        int numElements = output.length;
        for (int i = 0; i < numElements; ++i) {
            output[i] = iter.nextInt();
        }
    }
}

