/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.graph.dynamic.util;

import cytoscape.graph.dynamic.DynamicGraph;
import cytoscape.graph.dynamic.util.Edge;
import cytoscape.graph.dynamic.util.EdgeArray;
import cytoscape.graph.dynamic.util.EdgeDepot;
import cytoscape.graph.dynamic.util.Node;
import cytoscape.graph.dynamic.util.NodeArray;
import cytoscape.graph.dynamic.util.NodeDepot;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntIterator;
import cytoscape.util.intr.IntStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

final class DynamicGraphRepresentation
implements DynamicGraph,
Externalizable {
    private static final long serialVersionUID = 44615510L;
    private int m_nodeCount = 0;
    private int m_maxNode = -1;
    private int m_edgeCount = 0;
    private int m_maxEdge = -1;
    private Node m_firstNode = null;
    private final NodeArray m_nodes = new NodeArray();
    private final NodeDepot m_nodeDepot;
    private final EdgeArray m_edges = new EdgeArray();
    private final EdgeDepot m_edgeDepot = new EdgeDepot();
    private final IntStack m_stack;

    public DynamicGraphRepresentation() {
        this.m_nodeDepot = new NodeDepot();
        this.m_stack = new IntStack();
    }

    public final IntEnumerator nodes() {
        return new NodesEnumerator(this.m_nodeCount, this.m_firstNode);
    }

    public final IntEnumerator edges() {
        return new EdgesEnumerator(this.m_edgeCount, this.m_firstNode);
    }

    public final int nodeCreate() {
        int returnThis;
        Node n = this.m_nodeDepot.getNode();
        if (n.nodeId < 0) {
            n.nodeId = ++this.m_maxNode;
            returnThis = this.m_maxNode;
        } else {
            returnThis = n.nodeId;
        }
        this.m_nodes.setNodeAtIndex(n, returnThis);
        ++this.m_nodeCount;
        n.nextNode = this.m_firstNode;
        if (this.m_firstNode != null) {
            this.m_firstNode.prevNode = n;
        }
        this.m_firstNode = n;
        n.outDegree = 0;
        n.inDegree = 0;
        n.undDegree = 0;
        n.selfEdges = 0;
        return returnThis;
    }

    public final boolean nodeRemove(int node) {
        IntEnumerator edges = this.edgesAdjacent(node, true, true, true);
        if (edges == null) {
            return false;
        }
        this.m_stack.empty();
        while (edges.numRemaining() > 0) {
            this.m_stack.push(edges.nextInt());
        }
        while (this.m_stack.size() > 0) {
            this.edgeRemove(this.m_stack.pop());
        }
        Node n = this.m_nodes.getNodeAtIndex(node);
        if (n.prevNode != null) {
            n.prevNode.nextNode = n.nextNode;
        } else {
            this.m_firstNode = n.nextNode;
        }
        if (n.nextNode != null) {
            n.nextNode.prevNode = n.prevNode;
        }
        this.m_nodes.setNodeAtIndex(null, node);
        n.prevNode = null;
        n.firstOutEdge = null;
        n.firstInEdge = null;
        this.m_nodeDepot.recycleNode(n);
        --this.m_nodeCount;
        return true;
    }

    public final int edgeCreate(int sourceNode, int targetNode, boolean directed) {
        int returnThis;
        if (sourceNode < 0 || sourceNode == Integer.MAX_VALUE) {
            return -1;
        }
        Node source = this.m_nodes.getNodeAtIndex(sourceNode);
        if (targetNode < 0 || targetNode == Integer.MAX_VALUE) {
            return -1;
        }
        Node target = this.m_nodes.getNodeAtIndex(targetNode);
        if (source == null || target == null) {
            return -1;
        }
        Edge e = this.m_edgeDepot.getEdge();
        if (e.edgeId < 0) {
            e.edgeId = ++this.m_maxEdge;
            returnThis = this.m_maxEdge;
        } else {
            returnThis = e.edgeId;
        }
        this.m_edges.setEdgeAtIndex(e, returnThis);
        ++this.m_edgeCount;
        if (directed) {
            ++source.outDegree;
            ++target.inDegree;
        } else {
            ++source.undDegree;
            ++target.undDegree;
        }
        if (source == target) {
            if (directed) {
                ++source.selfEdges;
            } else {
                --source.undDegree;
            }
        }
        e.nextOutEdge = source.firstOutEdge;
        if (source.firstOutEdge != null) {
            source.firstOutEdge.prevOutEdge = e;
        }
        source.firstOutEdge = e;
        e.nextInEdge = target.firstInEdge;
        if (target.firstInEdge != null) {
            target.firstInEdge.prevInEdge = e;
        }
        target.firstInEdge = e;
        e.directed = directed;
        e.sourceNode = sourceNode;
        e.targetNode = targetNode;
        return returnThis;
    }

    public final boolean edgeRemove(int edge) {
        if (edge < 0 || edge == Integer.MAX_VALUE) {
            return false;
        }
        Edge e = this.m_edges.getEdgeAtIndex(edge);
        if (e == null) {
            return false;
        }
        Node source = this.m_nodes.getNodeAtIndex(e.sourceNode);
        Node target = this.m_nodes.getNodeAtIndex(e.targetNode);
        if (e.prevOutEdge != null) {
            e.prevOutEdge.nextOutEdge = e.nextOutEdge;
        } else {
            source.firstOutEdge = e.nextOutEdge;
        }
        if (e.nextOutEdge != null) {
            e.nextOutEdge.prevOutEdge = e.prevOutEdge;
        }
        if (e.prevInEdge != null) {
            e.prevInEdge.nextInEdge = e.nextInEdge;
        } else {
            target.firstInEdge = e.nextInEdge;
        }
        if (e.nextInEdge != null) {
            e.nextInEdge.prevInEdge = e.prevInEdge;
        }
        if (e.directed) {
            --source.outDegree;
            --target.inDegree;
        } else {
            --source.undDegree;
            --target.undDegree;
        }
        if (source == target) {
            if (e.directed) {
                --source.selfEdges;
            } else {
                ++source.undDegree;
            }
        }
        this.m_edges.setEdgeAtIndex(null, edge);
        e.prevOutEdge = null;
        e.nextInEdge = null;
        e.prevInEdge = null;
        this.m_edgeDepot.recycleEdge(e);
        --this.m_edgeCount;
        return true;
    }

    public final boolean nodeExists(int node) {
        if (node < 0 || node == Integer.MAX_VALUE) {
            return false;
        }
        return this.m_nodes.getNodeAtIndex(node) != null;
    }

    public final byte edgeType(int edge) {
        if (edge < 0 || edge == Integer.MAX_VALUE) {
            return -1;
        }
        Edge e = this.m_edges.getEdgeAtIndex(edge);
        if (e == null) {
            return -1;
        }
        if (e.directed) {
            return 1;
        }
        return 0;
    }

    public final int edgeSource(int edge) {
        if (edge < 0 || edge == Integer.MAX_VALUE) {
            return -1;
        }
        Edge e = this.m_edges.getEdgeAtIndex(edge);
        if (e == null) {
            return -1;
        }
        return e.sourceNode;
    }

    public final int edgeTarget(int edge) {
        if (edge < 0 || edge == Integer.MAX_VALUE) {
            return -1;
        }
        Edge e = this.m_edges.getEdgeAtIndex(edge);
        if (e == null) {
            return -1;
        }
        return e.targetNode;
    }

    public final IntEnumerator edgesAdjacent(int node, boolean outgoing, boolean incoming, boolean undirected) {
        if (node < 0 || node == Integer.MAX_VALUE) {
            return null;
        }
        Node n = this.m_nodes.getNodeAtIndex(node);
        if (n == null) {
            return null;
        }
        Edge[] edgeLists = undirected || outgoing && incoming ? new Edge[]{n.firstOutEdge, n.firstInEdge} : (outgoing ? new Edge[]{n.firstOutEdge, null} : (incoming ? new Edge[]{null, n.firstInEdge} : new Edge[]{null, null}));
        int tentativeEdgeCount = 0;
        if (outgoing) {
            tentativeEdgeCount += n.outDegree;
        }
        if (incoming) {
            tentativeEdgeCount += n.inDegree;
        }
        if (undirected) {
            tentativeEdgeCount += n.undDegree;
        }
        if (outgoing && incoming) {
            tentativeEdgeCount -= n.selfEdges;
        }
        return new EdgesAdjacentEnumerator(tentativeEdgeCount, edgeLists, undirected, incoming, outgoing);
    }

    public final IntIterator edgesConnecting(int node0, int node1, boolean outgoing, boolean incoming, boolean undirected) {
        int nodeOne;
        int nodeZero;
        IntEnumerator theAdj;
        IntEnumerator node0Adj = this.edgesAdjacent(node0, outgoing, incoming, undirected);
        IntEnumerator node1Adj = this.edgesAdjacent(node1, incoming, outgoing, undirected);
        if (node0Adj == null || node1Adj == null) {
            return null;
        }
        if (node0Adj.numRemaining() <= node1Adj.numRemaining()) {
            theAdj = node0Adj;
            nodeZero = node0;
            nodeOne = node1;
        } else {
            theAdj = node1Adj;
            nodeZero = node1;
            nodeOne = node0;
        }
        return new ConnectingEdgesIterator(theAdj, nodeZero, nodeOne, this);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        Object node;
        Edge edge;
        int i;
        out.writeInt(this.m_nodeCount);
        out.writeInt(this.m_maxNode);
        out.writeInt(this.m_edgeCount);
        out.writeInt(this.m_maxEdge);
        Node currNode = this.m_nodeDepot.m_head.nextNode;
        while (currNode != null) {
            out.writeInt(currNode.nodeId);
            currNode = currNode.nextNode;
        }
        out.writeInt(-1);
        Edge currEdge = this.m_edgeDepot.m_head.nextOutEdge;
        while (currEdge != null) {
            out.writeInt(currEdge.edgeId);
            currEdge = currEdge.nextOutEdge;
        }
        out.writeInt(-1);
        Object[] arr = this.m_edges.m_edgeArr;
        int arrLen = arr.length;
        out.writeInt(arrLen);
        for (i = 0; i < arrLen; ++i) {
            edge = arr[i];
            if (edge == null) {
                out.writeInt(-1);
                continue;
            }
            out.writeInt(edge.sourceNode);
            out.writeInt(edge.targetNode);
            out.writeBoolean(edge.directed);
        }
        for (i = 0; i < arrLen; ++i) {
            edge = arr[i];
            if (edge == null) continue;
            out.writeInt(edge.nextOutEdge == null ? -1 : edge.nextOutEdge.edgeId);
            out.writeInt(edge.prevOutEdge == null ? -1 : edge.prevOutEdge.edgeId);
            out.writeInt(edge.nextInEdge == null ? -1 : edge.nextInEdge.edgeId);
            out.writeInt(edge.prevInEdge == null ? -1 : edge.prevInEdge.edgeId);
        }
        arr = this.m_nodes.m_nodeArr;
        arrLen = arr.length;
        out.writeInt(arrLen);
        for (i = 0; i < arrLen; ++i) {
            node = arr[i];
            if (node == null) {
                out.writeInt(-1);
                continue;
            }
            out.writeInt(((Node)node).outDegree);
            out.writeInt(((Node)node).inDegree);
            out.writeInt(((Node)node).undDegree);
            out.writeInt(((Node)node).selfEdges);
        }
        for (i = 0; i < arrLen; ++i) {
            node = arr[i];
            if (node == null) continue;
            out.writeInt(((Node)node).nextNode == null ? -1 : ((Node)node).nextNode.nodeId);
            out.writeInt(((Node)node).prevNode == null ? -1 : ((Node)node).prevNode.nodeId);
            out.writeInt(((Node)node).firstOutEdge == null ? -1 : ((Node)node).firstOutEdge.edgeId);
            out.writeInt(((Node)node).firstInEdge == null ? -1 : ((Node)node).firstInEdge.edgeId);
        }
        if (this.m_firstNode == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.m_firstNode.nodeId);
        }
    }

    public final void readExternal(ObjectInput in) throws IOException {
        int i;
        int id;
        this.m_nodeCount = in.readInt();
        this.m_maxNode = in.readInt();
        this.m_edgeCount = in.readInt();
        this.m_maxEdge = in.readInt();
        Node currNode = this.m_nodeDepot.m_head;
        while ((id = in.readInt()) >= 0) {
            currNode = currNode.nextNode = new Node();
            currNode.nodeId = id;
        }
        Edge currEdge = this.m_edgeDepot.m_head;
        while ((id = in.readInt()) >= 0) {
            currEdge = currEdge.nextOutEdge = new Edge();
            currEdge.edgeId = id;
        }
        int arrLen = in.readInt();
        this.m_edges.m_edgeArr = new Edge[arrLen];
        Object[] arr = this.m_edges.m_edgeArr;
        for (i = 0; i < arrLen; ++i) {
            int source = in.readInt();
            if (source < 0) continue;
            Edge edge = arr[i] = new Edge();
            edge.edgeId = i;
            edge.sourceNode = source;
            edge.targetNode = in.readInt();
            edge.directed = in.readBoolean();
        }
        for (i = 0; i < arrLen; ++i) {
            Edge edge = arr[i];
            if (edge == null) continue;
            int nextOutEdge = in.readInt();
            int prevOutEdge = in.readInt();
            int nextInEdge = in.readInt();
            int prevInEdge = in.readInt();
            if (nextOutEdge >= 0) {
                edge.nextOutEdge = arr[nextOutEdge];
            }
            if (prevOutEdge >= 0) {
                edge.prevOutEdge = arr[prevOutEdge];
            }
            if (nextInEdge >= 0) {
                edge.nextInEdge = arr[nextInEdge];
            }
            if (prevInEdge < 0) continue;
            edge.prevInEdge = arr[prevInEdge];
        }
        arrLen = in.readInt();
        this.m_nodes.m_nodeArr = new Node[arrLen];
        arr = this.m_nodes.m_nodeArr;
        for (i = 0; i < arrLen; ++i) {
            int outDeg = in.readInt();
            if (outDeg < 0) continue;
            arr[i] = new Node();
            Node node = arr[i];
            node.nodeId = i;
            node.outDegree = outDeg;
            node.inDegree = in.readInt();
            node.undDegree = in.readInt();
            node.selfEdges = in.readInt();
        }
        Edge[] edgeArr = this.m_edges.m_edgeArr;
        for (int i2 = 0; i2 < arrLen; ++i2) {
            Object node = arr[i2];
            if (node == null) continue;
            int nextNode = in.readInt();
            int prevNode = in.readInt();
            int firstOutEdge = in.readInt();
            int firstInEdge = in.readInt();
            if (nextNode >= 0) {
                ((Node)node).nextNode = arr[nextNode];
            }
            if (prevNode >= 0) {
                ((Node)node).prevNode = arr[prevNode];
            }
            if (firstOutEdge >= 0) {
                ((Node)node).firstOutEdge = edgeArr[firstOutEdge];
            }
            if (firstInEdge < 0) continue;
            ((Node)node).firstInEdge = edgeArr[firstInEdge];
        }
        int firstNode = in.readInt();
        if (firstNode >= 0) {
            this.m_firstNode = this.m_nodes.m_nodeArr[firstNode];
        }
    }

    private class ConnectingEdgesIterator
    implements IntIterator {
        private int nextEdge = -1;
        private final IntEnumerator theAdj;
        private final int nodeZero;
        private final int nodeOne;
        private final DynamicGraph graph;

        ConnectingEdgesIterator(IntEnumerator theAdj, int nodeZero, int nodeOne, DynamicGraph graph) {
            this.theAdj = theAdj;
            this.nodeZero = nodeZero;
            this.nodeOne = nodeOne;
            this.graph = graph;
        }

        private void ensureComputeNext() {
            if (this.nextEdge != -1) {
                return;
            }
            while (this.theAdj.numRemaining() > 0) {
                int edge = this.theAdj.nextInt();
                if (this.nodeOne != (this.nodeZero ^ this.graph.edgeSource(edge) ^ this.graph.edgeTarget(edge))) continue;
                this.nextEdge = edge;
                return;
            }
            this.nextEdge = -2;
        }

        public final boolean hasNext() {
            this.ensureComputeNext();
            return this.nextEdge >= 0;
        }

        public final int nextInt() {
            this.ensureComputeNext();
            int returnThis = this.nextEdge;
            this.nextEdge = -1;
            return returnThis;
        }
    }

    private class EdgesAdjacentEnumerator
    implements IntEnumerator {
        private int numRemaining;
        private int edgeListIndex = -1;
        private Edge edge = null;
        private final Edge[] edgeLists;
        private final boolean undirected;
        private final boolean incoming;
        private final boolean outgoing;

        EdgesAdjacentEnumerator(int edgeCount, Edge[] edgeLists, boolean undirected, boolean incoming, boolean outgoing) {
            this.numRemaining = edgeCount;
            this.edgeLists = edgeLists;
            this.undirected = undirected;
            this.incoming = incoming;
            this.outgoing = outgoing;
        }

        public final int numRemaining() {
            return this.numRemaining;
        }

        public final int nextInt() {
            while (this.edge == null) {
                this.edge = this.edgeLists[++this.edgeListIndex];
            }
            int returnThis = -1;
            if (this.edgeListIndex == 0) {
                while (!(this.edge == null || this.outgoing && this.edge.directed || this.undirected && !this.edge.directed)) {
                    this.edge = this.edge.nextOutEdge;
                    if (this.edge != null) continue;
                    this.edge = this.edgeLists[++this.edgeListIndex];
                    break;
                }
                if (this.edge != null && this.edgeListIndex == 0) {
                    returnThis = this.edge.edgeId;
                    this.edge = this.edge.nextOutEdge;
                }
            }
            if (this.edgeListIndex == 1) {
                while (this.edge.sourceNode == this.edge.targetNode && (this.outgoing && this.edge.directed || this.undirected && !this.edge.directed) || (!this.incoming || !this.edge.directed) && (!this.undirected || this.edge.directed)) {
                    this.edge = this.edge.nextInEdge;
                }
                returnThis = this.edge.edgeId;
                this.edge = this.edge.nextInEdge;
            }
            --this.numRemaining;
            return returnThis;
        }
    }

    private class EdgesEnumerator
    implements IntEnumerator {
        private int numRemaining;
        private Node node;
        private Edge edge;

        EdgesEnumerator(int edgeCount, Node firstNode) {
            this.numRemaining = edgeCount;
            this.node = firstNode;
        }

        public final int numRemaining() {
            return this.numRemaining;
        }

        public final int nextInt() {
            int returnThis;
            if (this.edge != null) {
                returnThis = this.edge.edgeId;
            } else {
                this.edge = this.node.firstOutEdge;
                while (this.edge == null) {
                    this.node = this.node.nextNode;
                    this.edge = this.node.firstOutEdge;
                }
                this.node = this.node.nextNode;
                returnThis = this.edge.edgeId;
            }
            this.edge = this.edge.nextOutEdge;
            --this.numRemaining;
            return returnThis;
        }
    }

    private class NodesEnumerator
    implements IntEnumerator {
        private int numRemaining;
        private Node node;

        NodesEnumerator(int nodeCount, Node firstNode) {
            this.numRemaining = nodeCount;
            this.node = firstNode;
        }

        public final int numRemaining() {
            return this.numRemaining;
        }

        public final int nextInt() {
            int returnThis = this.node.nodeId;
            this.node = this.node.nextNode;
            --this.numRemaining;
            return returnThis;
        }
    }
}

