/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree.test;

import cytoscape.geom.rtree.RTree;
import java.io.IOException;
import java.io.InputStream;

public class RTreeUpdatePerformance {
    public static void main(String[] args) throws Exception {
        int read;
        int N = Integer.parseInt(args[1]);
        int branches = Integer.parseInt(args[0]);
        float[] data = new float[N * 4];
        double sqrtN = Math.sqrt(N);
        InputStream in = System.in;
        byte[] buff = new byte[16];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            int nonnegative = Integer.MAX_VALUE & RTreeUpdatePerformance.assembleInt(buff, 0);
            double centerX = (double)nonnegative / 2.147483647E9;
            nonnegative = Integer.MAX_VALUE & RTreeUpdatePerformance.assembleInt(buff, 4);
            double centerY = (double)nonnegative / 2.147483647E9;
            nonnegative = Integer.MAX_VALUE & RTreeUpdatePerformance.assembleInt(buff, 8);
            double width = (double)nonnegative / 2.147483647E9 / sqrtN;
            nonnegative = Integer.MAX_VALUE & RTreeUpdatePerformance.assembleInt(buff, 12);
            double height = (double)nonnegative / 2.147483647E9 / sqrtN;
            data[inx * 4] = (float)(centerX - width / 2.0);
            data[inx * 4 + 1] = (float)(centerY - height / 2.0);
            data[inx * 4 + 2] = (float)(centerX + width / 2.0);
            data[inx * 4 + 3] = (float)(centerY + height / 2.0);
            ++inx;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        RTree tree = new RTree(branches);
        for (int i = 0; i < 2; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
        long millisBegin = System.currentTimeMillis();
        int objKey = 0;
        inx = 0;
        while (objKey < N) {
            tree.insert(objKey++, data[inx++], data[inx++], data[inx++], data[inx++]);
        }
        long millisEnd = System.currentTimeMillis();
        System.err.println("initial insertions took " + (millisEnd - millisBegin) + " milliseconds");
        for (int i = 0; i < 2; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
        millisBegin = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            tree.queryOverlap((float)i * 0.1f, (float)i * 0.1f, (float)(i + 1) * 0.1f, (float)(i + 1) * 0.1f, null, 0, false);
        }
        long millisEnd2 = System.currentTimeMillis();
        System.err.println("initial area queries (5) took " + (millisEnd2 - millisBegin) + " milliseconds");
        for (int i = 0; i < 2; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
        millisBegin = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            tree.queryOverlap((float)i * 0.1f, (float)i * 0.1f, (float)i * 0.1f, (float)i * 0.1f, null, 0, false);
        }
        millisEnd = System.currentTimeMillis();
        System.err.println("initial point queries (5) took " + (millisEnd - millisBegin) + " milliseconds");
        for (int i = 0; i < 2; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
        float[] extents = new float[4];
        long millisBegin2 = System.currentTimeMillis();
        int objKey2 = 0;
        while (objKey2 < N) {
            tree.exists(objKey2++, extents, 0);
        }
        millisEnd = System.currentTimeMillis();
        System.err.println("all extents queries took " + (millisEnd - millisBegin2) + " milliseconds");
        for (int a = 0; a < 3; a = (int)((byte)(a + 1))) {
            for (int i = 0; i < 2; ++i) {
                System.gc();
                Thread.sleep(1000L);
            }
            millisBegin = System.currentTimeMillis();
            objKey2 = 0;
            int inx2 = 0;
            while (objKey2 < N) {
                tree.delete(objKey2);
                tree.insert(objKey2++, data[inx2++], data[inx2++], data[inx2++], data[inx2++]);
            }
            long millisEnd3 = System.currentTimeMillis();
            System.err.println("updates took " + (millisEnd3 - millisBegin) + " milliseconds");
            for (int i = 0; i < 2; ++i) {
                System.gc();
                Thread.sleep(1000L);
            }
            millisBegin = System.currentTimeMillis();
            switch (a) {
                case 0: {
                    int i;
                    for (i = 0; i < 5; ++i) {
                        tree.queryOverlap((float)i * 0.1f, (float)(9 - i) * 0.1f, (float)(i + 1) * 0.1f, (float)(10 - i) * 0.1f, null, 0, false);
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < 5; ++i) {
                        tree.queryOverlap((float)(9 - i) * 0.1f, (float)i * 0.1f, (float)(10 - i) * 0.1f, (float)(i + 1) * 0.1f, null, 0, false);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < 5; ++i) {
                        tree.queryOverlap((float)(9 - i) * 0.1f, (float)(9 - i) * 0.1f, (float)(10 - i) * 0.1f, (float)(10 - i) * 0.1f, null, 0, false);
                    }
                    break;
                }
            }
            long millisEnd4 = System.currentTimeMillis();
            System.err.println("repeated area queries (5) took " + (millisEnd4 - millisBegin) + " milliseconds");
            for (int i = 0; i < 2; ++i) {
                System.gc();
                Thread.sleep(1000L);
            }
            millisBegin2 = System.currentTimeMillis();
            switch (a) {
                case 0: {
                    for (int i = 0; i < 5; ++i) {
                        tree.queryOverlap((float)i * 0.1f, (float)(10 - i) * 0.1f, (float)i * 0.1f, (float)(10 - i) * 0.1f, null, 0, false);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < 5; ++i) {
                        tree.queryOverlap((float)(10 - i) * 0.1f, (float)i * 0.1f, (float)(10 - i) * 0.1f, (float)i * 0.1f, null, 0, false);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < 5; ++i) {
                        tree.queryOverlap((float)(10 - i) * 0.1f, (float)(10 - i) * 0.1f, (float)(10 - i) * 0.1f, (float)(10 - i) * 0.1f, null, 0, false);
                    }
                    break;
                }
            }
            millisEnd = System.currentTimeMillis();
            System.err.println("repeated point queries (5) took " + (millisEnd - millisBegin2) + " milliseconds");
        }
    }

    private static int assembleInt(byte[] bytes, int offset) {
        int firstByte = (bytes[offset] & 0xFF) << 24;
        int secondByte = (bytes[offset + 1] & 0xFF) << 16;
        int thirdByte = (bytes[offset + 2] & 0xFF) << 8;
        int fourthByte = (bytes[offset + 3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }
}

