/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SelectionModeAction
extends JMenu
implements MenuListener {
    JCheckBoxMenuItem nodes;
    JCheckBoxMenuItem edges;
    JCheckBoxMenuItem nodesAndEdges;

    public SelectionModeAction() {
        super("Mouse Drag Selects");
        ButtonGroup modeGroup = new ButtonGroup();
        this.nodes = new JCheckBoxMenuItem(new AbstractAction("Nodes Only"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Cytoscape.setSelectionMode(1);
                    }
                });
            }
        });
        this.nodes.setAccelerator(KeyStroke.getKeyStroke(75, 3));
        this.edges = new JCheckBoxMenuItem(new AbstractAction("Edges Only"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Cytoscape.setSelectionMode(2);
                    }
                });
            }
        });
        this.edges.setAccelerator(KeyStroke.getKeyStroke(75, 10));
        this.nodesAndEdges = new JCheckBoxMenuItem(new AbstractAction("Nodes and Edges"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Cytoscape.setSelectionMode(3);
                    }
                });
            }
        });
        this.nodesAndEdges.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        modeGroup.add(this.nodes);
        modeGroup.add(this.edges);
        modeGroup.add(this.nodesAndEdges);
        this.add(this.nodes);
        this.add(this.edges);
        this.add(this.nodesAndEdges);
        this.nodesAndEdges.setSelected(true);
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        view.enableNodeSelection();
        view.enableEdgeSelection();
        Cytoscape.setSelectionMode(3);
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        CyNetwork n = Cytoscape.getCurrentNetwork();
        if (n == null || n == Cytoscape.getNullNetwork()) {
            this.nodes.setEnabled(false);
            this.edges.setEnabled(false);
            this.nodesAndEdges.setEnabled(false);
        } else {
            this.nodes.setEnabled(true);
            this.edges.setEnabled(true);
            this.nodesAndEdges.setEnabled(true);
        }
    }
}

