/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.util.CytoscapeAction;
import cytoscape.util.MemoryReporter;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class MemoryUsageAction
extends CytoscapeAction {
    public MemoryUsageAction() {
        super("Memory Usage...");
        this.setPreferredMenu("Help");
    }

    public void actionPerformed(ActionEvent e) {
        StringBuilder msg = new StringBuilder("used:           " + this.roundToNearestMiB(MemoryReporter.getUsedMemory()) + "MiB\n");
        long maximum = MemoryReporter.getMaxMemory();
        if (maximum == -1L) {
            msg.append("maximum:   not available!");
        } else {
            msg.append("maximum:   " + this.roundToNearestMiB(maximum) + "MiB\n");
        }
        msg.append("committed:  " + this.roundToNearestMiB(MemoryReporter.getCommittedMemory()) + "MiB\n");
        JOptionPane.showMessageDialog(null, msg.toString(), "Memory Usage", 1);
    }

    private long roundToNearestMiB(long noOfBytes) {
        return (noOfBytes + 524288L) / 0x100000L;
    }
}

