/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.interpreter.Instruction;
import org.cytoscape.equations.parse_tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SConvNode
extends Node {
    private final Node convertee;

    public SConvNode(Node convertee) {
        super(-1);
        if (convertee == null) {
            throw new IllegalArgumentException("convertee must not be null!");
        }
        Class type = convertee.getType();
        if (type != Double.class && type != Long.class && type != Boolean.class) {
            throw new IllegalArgumentException("convertee must be of type Double, Long, or Boolean!");
        }
        this.convertee = convertee;
    }

    @Override
    public String toString() {
        return "SConvNode: convertee = " + this.convertee;
    }

    @Override
    public Class getType() {
        return String.class;
    }

    @Override
    public Node getLeftChild() {
        return this.convertee;
    }

    @Override
    public Node getRightChild() {
        return null;
    }

    @Override
    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.convertee.genCode(codeStack);
        Class type = this.convertee.getType();
        if (type == Double.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONVF, this.getSourceLocation()));
        } else if (type == Long.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONVI, this.getSourceLocation()));
        } else if (type == Boolean.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONVB, this.getSourceLocation()));
        } else {
            throw new IllegalStateException("unknown type: " + type + "!");
        }
    }
}

