/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Max
extends AbstractFunction {
    public Max() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "Any combination of lists of numbers or individual numbers.")});
    }

    public String getName() {
        return "MAX";
    }

    public String getFunctionSummary() {
        return "Returns the maximum of a group of numbers.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to a number in a call to MAX()!");
        }
        double max = Double.NEGATIVE_INFINITY;
        for (double d : numbers) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }
}

