/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenbankXmlFormat
extends GenbankFormat {
    private SAXParser m_xmlParser;
    private GenbankXmlHandler m_handler;
    private boolean m_parsed = false;
    private int m_sequenceIndex;

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!this.m_parsed) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            try {
                this.m_xmlParser = factory.newSAXParser();
            }
            catch (ParserConfigurationException ex) {
                throw new ParseException(ex);
            }
            catch (SAXException ex) {
                throw new ParseException(ex);
            }
            InputSource source = new InputSource(reader);
            this.m_handler = new GenbankXmlHandler();
            try {
                this.m_xmlParser.parse(source, (DefaultHandler)this.m_handler);
            }
            catch (SAXException ex) {
                throw new ParseException(ex);
            }
            this.m_parsed = true;
        }
        ArrayList sequences = this.m_handler.getSequences();
        listener.startSequence();
        GenbankXmlSequence sequence = (GenbankXmlSequence)sequences.get(this.m_sequenceIndex++);
        this.generateSequenceForListener(sequence, listener, symParser);
        listener.endSequence();
        return this.m_sequenceIndex < sequences.size();
    }

    private void generateSequenceForListener(GenbankXmlSequence sequence, SeqIOListener listener, SymbolTokenization symParser) throws ParseException, IllegalSymbolException {
        String accessionVersion;
        String topology;
        String moltype;
        listener.addSequenceProperty("LOCUS", sequence.getLocus());
        listener.addSequenceProperty("SIZE", sequence.getLength());
        String strandedness = sequence.getStrandedness();
        if (strandedness != null) {
            listener.addSequenceProperty("STRANDS", this.convertToStrandednessName(strandedness));
        }
        if ((moltype = sequence.getMolType()) != null) {
            listener.addSequenceProperty("TYPE", this.convertToMolTypeName(moltype));
        }
        if ((topology = sequence.getTopology()) != null) {
            listener.addSequenceProperty("CIRCULAR", this.convertToTopologyName(topology));
        }
        listener.addSequenceProperty("DIVISION", sequence.getDivision());
        listener.addSequenceProperty("MDAT", sequence.getUpdateDate());
        listener.addSequenceProperty("DEFINITION", sequence.getDefinition());
        String primaryAccession = sequence.getPrimaryAccession();
        if (primaryAccession != null) {
            listener.addSequenceProperty("ACCESSION", primaryAccession);
        }
        if ((accessionVersion = sequence.getAccessionVersion()) != null) {
            listener.addSequenceProperty("VERSION", accessionVersion);
        }
        this.handleOtherSequenceIds(sequence, listener);
        this.handleKeywords(sequence, listener);
        listener.addSequenceProperty("SOURCE", sequence.getSource());
        listener.addSequenceProperty("ORGANISM", sequence.getOrganism() + sequence.getTaxonomy());
        this.handleReferences(sequence, listener);
        String comment = sequence.getComment();
        if (comment != null) {
            listener.addSequenceProperty("COMMENT", comment);
        }
        this.handleFeatures(sequence, listener);
        String seq = sequence.getSequence();
        if (seq != null && !this.getElideSymbols()) {
            StreamParser streamParser = symParser.parseStream(listener);
            streamParser.characters(seq.toCharArray(), 0, seq.length());
        }
    }

    private void handleOtherSequenceIds(GenbankXmlSequence sequence, SeqIOListener listener) throws ParseException {
        ArrayList otherSeqIds = sequence.getOtherSequencesIds();
        ListIterator iter = otherSeqIds.listIterator();
        while (iter.hasNext()) {
            String seqId = (String)iter.next();
            if (!seqId.startsWith("gi|")) continue;
            listener.addSequenceProperty("GI", seqId.substring(3));
        }
    }

    private void handleKeywords(GenbankXmlSequence sequence, SeqIOListener listener) throws ParseException {
        ArrayList keywords = sequence.getKeywords();
        ListIterator iter = keywords.listIterator();
        while (iter.hasNext()) {
            String keyword = (String)iter.next();
            listener.addSequenceProperty("KEYWORDS", keyword);
        }
    }

    private void handleReferences(GenbankXmlSequence sequence, SeqIOListener listener) throws ParseException {
        ArrayList references = sequence.getReferences();
        ListIterator iter = references.listIterator();
        while (iter.hasNext()) {
            String medline;
            GenbankXmlReference reference = (GenbankXmlReference)iter.next();
            listener.addSequenceProperty("REFERENCE", reference.getReference());
            ArrayList authors = reference.getAuthors();
            ListIterator authorIter = authors.listIterator();
            StringBuffer theAuthors = new StringBuffer("");
            while (authorIter.hasNext()) {
                String author = (String)authorIter.next();
                theAuthors.append(author);
                if (!authorIter.hasNext()) continue;
                theAuthors.append(", ");
            }
            listener.addSequenceProperty("AUTHORS", theAuthors.toString());
            String title = reference.getTitle();
            if (title != null) {
                listener.addSequenceProperty("TITLE", title);
            }
            listener.addSequenceProperty("JOURNAL", reference.getJournal());
            String pubmed = reference.getPubmed();
            if (pubmed != null) {
                listener.addSequenceProperty("PUBMED", pubmed);
            }
            if ((medline = reference.getMedline()) == null) continue;
            listener.addSequenceProperty("MEDLINE", medline);
        }
    }

    private void handleFeatures(GenbankXmlSequence sequence, SeqIOListener listener) throws ParseException {
        ArrayList features = sequence.getFeatures();
        ListIterator iter = features.listIterator();
        while (iter.hasNext()) {
            GenbankXmlFeature feature = (GenbankXmlFeature)iter.next();
            String key = feature.getKey();
            int keyLength = key.length();
            String featureString = feature.getKey() + this.createBlankString(16 - keyLength) + feature.getLocation();
            listener.addSequenceProperty("FT", featureString);
            ArrayList qualifiers = feature.getQualifiers();
            ListIterator qualifiersIter = qualifiers.listIterator();
            while (qualifiersIter.hasNext()) {
                GenbankXmlQualifier qualifier = (GenbankXmlQualifier)qualifiersIter.next();
                String qualifierString = "                /" + qualifier.getName() + "=" + "\"" + qualifier.getValue() + "\"";
                listener.addSequenceProperty("FT", qualifierString);
            }
        }
    }

    public String getDefaultFormat() {
        return "GenbankXml";
    }

    private String createBlankString(int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String convertToStrandednessName(String strandednessIndex) throws ParseException {
        int i = Integer.parseInt(strandednessIndex);
        switch (i) {
            case 0: {
                return "not-set";
            }
            case 1: {
                return "single-stranded";
            }
            case 2: {
                return "double-stranded";
            }
            case 3: {
                return "mixed-stranded";
            }
        }
        throw new ParseException("Unknown strandedness: " + strandednessIndex);
    }

    private String convertToMolTypeName(String moltypeIndex) throws ParseException {
        int i = Integer.parseInt(moltypeIndex);
        switch (i) {
            case 0: {
                return "nucleic-acid";
            }
            case 1: {
                return "dna";
            }
            case 2: {
                return "rna";
            }
            case 3: {
                return "trna";
            }
            case 4: {
                return "rrna";
            }
            case 5: {
                return "mrna";
            }
            case 6: {
                return "urna";
            }
            case 7: {
                return "snrna";
            }
            case 8: {
                return "snorna";
            }
            case 9: {
                return "peptide";
            }
        }
        throw new ParseException("Unknown molecule type: " + i);
    }

    private String convertToTopologyName(String topologyIndex) throws ParseException {
        int i = Integer.parseInt(topologyIndex);
        switch (i) {
            case 1: {
                return "linear";
            }
            case 2: {
                return "circular";
            }
        }
        throw new ParseException("Unknown topology: " + i);
    }

    private static class GenbankXmlInterval {
        private String m_from;
        private String m_to;
        private String m_point;
        private String m_accession;

        private GenbankXmlInterval() {
        }

        private void setFrom(String from) {
            this.m_from = from;
        }

        private String getFrom() {
            return this.m_from;
        }

        private void setTo(String to) {
            this.m_to = to;
        }

        private String getTo() {
            return this.m_to;
        }

        private void setPoint(String point) {
            this.m_point = point;
        }

        private String getPoint() {
            return this.m_point;
        }

        private void setAccession(String accession) {
            this.m_accession = accession;
        }

        private String getAccession() {
            return this.m_accession;
        }
    }

    private static class GenbankXmlQualifier {
        private String m_name;
        private String m_value;

        private GenbankXmlQualifier() {
        }

        private void setName(String name) {
            this.m_name = name;
        }

        private String getName() {
            return this.m_name;
        }

        private void setValue(String value) {
            this.m_value = value;
        }

        private String getValue() {
            return this.m_value;
        }
    }

    private static class GenbankXmlFeature {
        private String m_key;
        private String m_location;
        private ArrayList m_intervals = new ArrayList();
        private GenbankXmlInterval m_currInterval;
        private ArrayList m_qualifiers = new ArrayList();
        private GenbankXmlQualifier m_currQualifier;

        private GenbankXmlFeature() {
        }

        private void setKey(String key) {
            this.m_key = key;
        }

        private String getKey() {
            return this.m_key;
        }

        private void setLocation(String location) {
            this.m_location = location;
        }

        private String getLocation() {
            return this.m_location;
        }

        private void addNewInterval() {
            this.m_currInterval = new GenbankXmlInterval();
            this.m_intervals.add(this.m_currInterval);
        }

        private GenbankXmlInterval getCurrentInterval() {
            return this.m_currInterval;
        }

        private ArrayList getIntervals() {
            return new ArrayList(this.m_intervals);
        }

        private void addNewQualifier() {
            this.m_currQualifier = new GenbankXmlQualifier();
            this.m_qualifiers.add(this.m_currQualifier);
        }

        private GenbankXmlQualifier getCurrentQualifier() {
            return this.m_currQualifier;
        }

        private ArrayList getQualifiers() {
            return new ArrayList(this.m_qualifiers);
        }
    }

    private static class GenbankXmlReference {
        private String m_reference;
        private ArrayList m_authors = new ArrayList();
        private String m_consortium;
        private String m_title;
        private String m_journal;
        private String m_medline;
        private String m_pubmed;
        private String m_remark;

        private GenbankXmlReference() {
        }

        private void setReference(String reference) {
            this.m_reference = reference;
        }

        private String getReference() {
            return this.m_reference;
        }

        private void addAuthor(String author) {
            this.m_authors.add(author);
        }

        private ArrayList getAuthors() {
            return new ArrayList(this.m_authors);
        }

        private void setConsortium(String consortium) {
            this.m_consortium = consortium;
        }

        private String getConsortium() {
            return this.m_consortium;
        }

        private void setTitle(String title) {
            this.m_title = title;
        }

        private String getTitle() {
            return this.m_title;
        }

        private void setJournal(String journal) {
            this.m_journal = journal;
        }

        private String getJournal() {
            return this.m_journal;
        }

        private void setMedline(String medline) {
            this.m_medline = medline;
        }

        private String getMedline() {
            return this.m_medline;
        }

        private void setPubmed(String pubmed) {
            this.m_pubmed = pubmed;
        }

        private String getPubmed() {
            return this.m_pubmed;
        }

        private void setRemark(String remark) {
            this.m_remark = remark;
        }

        private String getRemark() {
            return this.m_remark;
        }
    }

    private static class GenbankXmlSequence {
        private String m_locus;
        private String m_length;
        private String m_strandedness;
        private String m_moltype;
        private String m_topology;
        private String m_division;
        private String m_updateDate;
        private String m_createDate;
        private String m_updateRelease;
        private String m_createRelease;
        private String m_definition;
        private String m_primaryAccession;
        private String m_entryVersion;
        private String m_accessionVersion;
        private ArrayList m_otherSeqIds = new ArrayList();
        private ArrayList m_secondaryAccessions = new ArrayList();
        private ArrayList m_keywords = new ArrayList();
        private String m_segment;
        private String m_source;
        private String m_organism;
        private String m_taxonomy;
        private ArrayList m_references = new ArrayList();
        private GenbankXmlReference m_currReference;
        private String m_comment;
        private String m_primary;
        private String m_sourceDb;
        private String m_databaseReference;
        private ArrayList m_features = new ArrayList();
        private GenbankXmlFeature m_currFeature;
        private String m_sequence;
        private String m_contig;

        private GenbankXmlSequence() {
        }

        private void setLocus(String locus) {
            this.m_locus = locus;
        }

        private String getLocus() {
            return this.m_locus;
        }

        private void setLength(String length) {
            this.m_length = length;
        }

        private String getLength() {
            return this.m_length;
        }

        private void setStrandedness(String strandedness) {
            this.m_strandedness = strandedness;
        }

        private String getStrandedness() {
            return this.m_strandedness;
        }

        private void setMolType(String moltype) {
            this.m_moltype = moltype;
        }

        private String getMolType() {
            return this.m_moltype;
        }

        private void setTopology(String topology) {
            this.m_topology = topology;
        }

        private String getTopology() {
            return this.m_topology;
        }

        private void setDivision(String division) {
            this.m_division = division;
        }

        private String getDivision() {
            return this.m_division;
        }

        private void setUpdateDate(String updateDate) {
            this.m_updateDate = updateDate;
        }

        private String getUpdateDate() {
            return this.m_updateDate;
        }

        private void setCreateDate(String createDate) {
            this.m_createDate = createDate;
        }

        private String getCreateDate() {
            return this.m_createDate;
        }

        private void setUpdateRelease(String updateRelease) {
            this.m_updateRelease = updateRelease;
        }

        private String getUpdateRelease() {
            return this.m_updateRelease;
        }

        private void setCreateRelease(String createRelease) {
            this.m_createRelease = createRelease;
        }

        private String getCreateRelease() {
            return this.m_createRelease;
        }

        private void setDefinition(String definition) {
            this.m_definition = definition;
        }

        private String getDefinition() {
            return this.m_definition;
        }

        private void setPrimaryAccession(String primaryAccession) {
            this.m_primaryAccession = primaryAccession;
        }

        private String getPrimaryAccession() {
            return this.m_primaryAccession;
        }

        private void setEntryVersion(String entryVersion) {
            this.m_entryVersion = entryVersion;
        }

        private String getEntryVersion() {
            return this.m_entryVersion;
        }

        private void setAccessionVersion(String accessionVersion) {
            this.m_accessionVersion = accessionVersion;
        }

        private String getAccessionVersion() {
            return this.m_accessionVersion;
        }

        private void addOtherSequenceId(String seqId) {
            this.m_otherSeqIds.add(seqId);
        }

        private ArrayList getOtherSequencesIds() {
            return new ArrayList(this.m_otherSeqIds);
        }

        private void addSecondaryAccession(String secondaryAccession) {
            this.m_secondaryAccessions.add(secondaryAccession);
        }

        private ArrayList getSecondaryAccessions() {
            return new ArrayList(this.m_secondaryAccessions);
        }

        private void addKeyword(String keyword) {
            this.m_keywords.add(keyword);
        }

        private ArrayList getKeywords() {
            return new ArrayList(this.m_keywords);
        }

        private void setSegment(String segment) {
            this.m_segment = segment;
        }

        private String getSegment() {
            return this.m_segment;
        }

        private void setSource(String source) {
            this.m_source = source;
        }

        private String getSource() {
            return this.m_source;
        }

        private void setOrganism(String organism) {
            this.m_organism = organism;
        }

        private String getOrganism() {
            return this.m_organism;
        }

        private void setTaxonomy(String taxonomy) {
            this.m_taxonomy = taxonomy;
        }

        private String getTaxonomy() {
            return this.m_taxonomy;
        }

        private void addNewReference() {
            this.m_currReference = new GenbankXmlReference();
            this.m_references.add(this.m_currReference);
        }

        private GenbankXmlReference getCurrentReference() {
            return this.m_currReference;
        }

        private ArrayList getReferences() {
            return new ArrayList(this.m_references);
        }

        private void setComment(String comment) {
            this.m_comment = comment;
        }

        private String getComment() {
            return this.m_comment;
        }

        private void setPrimary(String primary) {
            this.m_primary = primary;
        }

        private String getPrimary() {
            return this.m_primary;
        }

        private void setSourceDb(String sourceDb) {
            this.m_sourceDb = sourceDb;
        }

        private String getSourceDb() {
            return this.m_sourceDb;
        }

        private void setDatabaseReference(String databaseReference) {
            this.m_databaseReference = databaseReference;
        }

        private String getDatabaseReference() {
            return this.m_databaseReference;
        }

        private void addNewFeature() {
            this.m_currFeature = new GenbankXmlFeature();
            this.m_features.add(this.m_currFeature);
        }

        private GenbankXmlFeature getCurrentFeature() {
            return this.m_currFeature;
        }

        private ArrayList getFeatures() {
            return new ArrayList(this.m_features);
        }

        private void setSequence(String sequence) {
            this.m_sequence = sequence;
        }

        private String getSequence() {
            return this.m_sequence;
        }

        private void setContig(String contig) {
            this.m_contig = contig;
        }

        private String getContig() {
            return this.m_contig;
        }
    }

    private static class GenbankXmlHandler
    extends DefaultHandler {
        private GenbankXmlSequence m_currentSequence;
        private ArrayList m_sequences = new ArrayList();
        private StringBuffer m_currentString = new StringBuffer();

        private GenbankXmlHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("GBSeq")) {
                this.m_currentSequence = new GenbankXmlSequence();
            } else if (qName.equals("GBReference")) {
                this.m_currentSequence.addNewReference();
            } else if (qName.equals("GBFeature")) {
                this.m_currentSequence.addNewFeature();
            } else if (qName.equals("GBQualifier")) {
                this.m_currentSequence.getCurrentFeature().addNewQualifier();
            } else if (qName.equals("GBInterval")) {
                this.m_currentSequence.getCurrentFeature().addNewInterval();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("GBSet")) {
                return;
            }
            if (qName.equals("GBSeq")) {
                this.m_sequences.add(this.m_currentSequence);
            } else if (qName.equals("GBSeq_locus")) {
                this.m_currentSequence.setLocus(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_length")) {
                this.m_currentSequence.setLength(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_strandedness")) {
                this.m_currentSequence.setStrandedness(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_moltype")) {
                this.m_currentSequence.setMolType(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_topology")) {
                this.m_currentSequence.setTopology(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_division")) {
                this.m_currentSequence.setDivision(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_update-date")) {
                this.m_currentSequence.setUpdateDate(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_create-date")) {
                this.m_currentSequence.setCreateDate(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_update-release")) {
                this.m_currentSequence.setUpdateRelease(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_create-release")) {
                this.m_currentSequence.setCreateRelease(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_definition")) {
                this.m_currentSequence.setDefinition(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_primary-accession")) {
                this.m_currentSequence.setPrimaryAccession(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_entry-version")) {
                this.m_currentSequence.setEntryVersion(this.m_currentString.toString());
            } else if (qName.equals("GBSeq_accession-version")) {
                this.m_currentSequence.setAccessionVersion(this.m_currentString.toString());
            } else {
                if (qName.equals("GBSeq_other-seqids")) {
                    return;
                }
                if (qName.equals("GBSeqid")) {
                    this.m_currentSequence.addOtherSequenceId(this.m_currentString.toString());
                } else {
                    if (qName.equals("GBSeq_secondary-accessions")) {
                        return;
                    }
                    if (qName.equals("GBSecondary-accn")) {
                        this.m_currentSequence.addSecondaryAccession(this.m_currentString.toString());
                    } else {
                        if (qName.equals("GBSeq_keywords")) {
                            return;
                        }
                        if (qName.equals("GBKeyword")) {
                            this.m_currentSequence.addKeyword(this.m_currentString.toString());
                        } else if (qName.equals("GBSeq_segment")) {
                            this.m_currentSequence.setSegment(this.m_currentString.toString());
                        } else if (qName.equals("GBSeq_source")) {
                            this.m_currentSequence.setSource(this.m_currentString.toString());
                        } else if (qName.equals("GBSeq_organism")) {
                            this.m_currentSequence.setOrganism(this.m_currentString.toString());
                        } else if (qName.equals("GBSeq_taxonomy")) {
                            this.m_currentSequence.setTaxonomy(this.m_currentString.toString());
                        } else {
                            if (qName.equals("GBSeq_references")) {
                                return;
                            }
                            if (qName.equals("GBReference")) {
                                return;
                            }
                            if (qName.equals("GBReference_reference")) {
                                this.m_currentSequence.getCurrentReference().setReference(this.m_currentString.toString());
                            } else {
                                if (qName.equals("GBReference_authors")) {
                                    return;
                                }
                                if (qName.equals("GBAuthor")) {
                                    this.m_currentSequence.getCurrentReference().addAuthor(this.m_currentString.toString());
                                } else if (qName.equals("GBReference_consortium")) {
                                    this.m_currentSequence.getCurrentReference().setConsortium(this.m_currentString.toString());
                                } else if (qName.equals("GBReference_title")) {
                                    this.m_currentSequence.getCurrentReference().setTitle(this.m_currentString.toString());
                                } else if (qName.equals("GBReference_journal")) {
                                    this.m_currentSequence.getCurrentReference().setJournal(this.m_currentString.toString());
                                } else if (qName.equals("GBReference_medline")) {
                                    this.m_currentSequence.getCurrentReference().setMedline(this.m_currentString.toString());
                                } else if (qName.equals("GBReference_pubmed")) {
                                    this.m_currentSequence.getCurrentReference().setPubmed(this.m_currentString.toString());
                                } else if (qName.equals("GBReference_remark")) {
                                    this.m_currentSequence.getCurrentReference().setRemark(this.m_currentString.toString());
                                } else if (qName.equals("GBSeq_comment")) {
                                    this.m_currentSequence.setComment(this.m_currentString.toString());
                                } else if (qName.equals("GBSeq_primary")) {
                                    this.m_currentSequence.setPrimary(this.m_currentString.toString());
                                } else if (qName.equals("GBSeq_source-db")) {
                                    this.m_currentSequence.setSourceDb(this.m_currentString.toString());
                                } else if (qName.equals("GBSeq_database-reference")) {
                                    this.m_currentSequence.setDatabaseReference(this.m_currentString.toString());
                                } else {
                                    if (qName.equals("GBSeq_feature-table")) {
                                        return;
                                    }
                                    if (qName.equals("GBFeature")) {
                                        return;
                                    }
                                    if (qName.equals("GBFeature_key")) {
                                        this.m_currentSequence.getCurrentFeature().setKey(this.m_currentString.toString());
                                    } else if (qName.equals("GBFeature_location")) {
                                        this.m_currentSequence.getCurrentFeature().setLocation(this.m_currentString.toString());
                                    } else {
                                        if (qName.equals("GBFeature_intervals")) {
                                            return;
                                        }
                                        if (qName.equals("GBInterval")) {
                                            return;
                                        }
                                        if (qName.equals("GBInterval_from")) {
                                            this.m_currentSequence.getCurrentFeature().getCurrentInterval().setFrom(this.m_currentString.toString());
                                        } else if (qName.equals("GBInterval_to")) {
                                            this.m_currentSequence.getCurrentFeature().getCurrentInterval().setTo(this.m_currentString.toString());
                                        } else if (qName.equals("GBInterval_point")) {
                                            this.m_currentSequence.getCurrentFeature().getCurrentInterval().setPoint(this.m_currentString.toString());
                                        } else if (qName.equals("GBInterval_accession")) {
                                            this.m_currentSequence.getCurrentFeature().getCurrentInterval().setAccession(this.m_currentString.toString());
                                        } else {
                                            if (qName.equals("GBFeature_quals")) {
                                                return;
                                            }
                                            if (qName.equals("GBQualifier")) {
                                                return;
                                            }
                                            if (qName.equals("GBQualifier_name")) {
                                                this.m_currentSequence.getCurrentFeature().getCurrentQualifier().setName(this.m_currentString.toString());
                                            } else if (qName.equals("GBQualifier_value")) {
                                                this.m_currentSequence.getCurrentFeature().getCurrentQualifier().setValue(this.m_currentString.toString());
                                            } else if (qName.equals("GBSeq_sequence")) {
                                                this.m_currentSequence.setSequence(this.m_currentString.toString());
                                            } else if (qName.equals("GBSeq_contig")) {
                                                this.m_currentSequence.setContig(this.m_currentString.toString());
                                            } else {
                                                throw new SAXException("Unrecognized tag: " + qName);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.m_currentString.delete(0, this.m_currentString.length());
        }

        public void characters(char[] ch, int start, int length) {
            this.m_currentString.append(ch, start, length);
        }

        private ArrayList getSequences() {
            return this.m_sequences;
        }
    }
}

