/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHistStyle;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JASHist1DHistogramStyle
extends JASHistStyle
implements Serializable {
    public static final int SYMBOL_DOT = 0;
    public static final int SYMBOL_BOX = 1;
    public static final int SYMBOL_TRIANGLE = 2;
    public static final int SYMBOL_DIAMOND = 3;
    public static final int SYMBOL_STAR = 4;
    public static final int SYMBOL_VERT_LINE = 5;
    public static final int SYMBOL_HORIZ_LINE = 6;
    public static final int SYMBOL_CROSS = 7;
    public static final int SYMBOL_CIRCLE = 8;
    public static final int SYMBOL_SQUARE = 9;
    static final Color[] lineColors = new Color[]{Color.blue, Color.red, Color.magenta, Color.green, Color.orange, Color.cyan};
    static final int[] pointStyles = new int[]{0, 1, 2, 3, 4, 7, 8, 9};
    static int n = 0;
    static int np = 0;
    static final long serialVersionUID = 7779996364086801435L;
    private boolean m_histogramFill;
    private Color m_histogramBarColor;
    private Color m_histogramBarLineColor;
    private boolean histogramBarLineColorChanged = false;
    private Color m_errorBarColor;
    private Color m_lineColor;
    private Color m_dataPointColor;
    private int m_style;
    private int m_dataPointStyle;
    private int m_dataPointSize;
    private boolean m_showHistogramBars;
    private boolean m_showErrorBars;
    private boolean m_showDataPoints;
    private boolean m_showLinesBetweenPoints;
    private float m_linesBetweenPointsWidth;
    private int m_linesBetweenPointsStyle;
    private float m_errorBarWidth;
    private int m_errorBarStyle;
    private float m_errorBarDecoration = -1.0f;
    private float m_histogramBarLineWidth;
    private int m_histogramBarLineStyle;
    private boolean m_errorBarColorIsDefault;

    public JASHist1DHistogramStyle() {
        this.initTransientData();
        this.m_showDataPoints = false;
        this.m_showErrorBars = true;
        this.m_histogramFill = true;
        this.m_showHistogramBars = true;
        this.m_showLinesBetweenPoints = false;
        this.m_histogramBarLineWidth = 1.0f;
        this.m_linesBetweenPointsWidth = 1.0f;
        this.m_errorBarWidth = 1.0f;
        this.m_dataPointSize = 6;
        this.m_dataPointStyle = pointStyles[np];
        this.m_histogramBarColor = lineColors[n];
        this.m_histogramBarLineColor = Color.BLACK;
        this.m_errorBarColor = lineColors[n];
        this.m_errorBarColorIsDefault = true;
        this.m_dataPointColor = lineColors[n];
        this.m_lineColor = lineColors[n];
        ++np;
        if (++n == lineColors.length) {
            n = 0;
        }
        if (np == pointStyles.length) {
            np = 0;
        }
    }

    public boolean getShowHistogramBars() {
        return this.m_showHistogramBars;
    }

    public void setShowHistogramBars(boolean bNewValue) {
        this.m_showHistogramBars = bNewValue;
        this.changeNotify();
    }

    public boolean getShowErrorBars() {
        return this.m_showErrorBars;
    }

    public void setShowErrorBars(boolean bNewValue) {
        this.m_showErrorBars = bNewValue;
        this.changeNotify();
    }

    public boolean getShowDataPoints() {
        return this.m_showDataPoints;
    }

    public void setShowDataPoints(boolean bNewValue) {
        this.m_showDataPoints = bNewValue;
        this.changeNotify();
    }

    public boolean getShowLinesBetweenPoints() {
        return this.m_showLinesBetweenPoints;
    }

    public void setShowLinesBetweenPoints(boolean bNewValue) {
        this.m_showLinesBetweenPoints = bNewValue;
        this.changeNotify();
    }

    public int getLinesBetweenPointsStyle() {
        return this.m_linesBetweenPointsStyle;
    }

    public void setLinesBetweenPointsStyle(int style) {
        this.m_linesBetweenPointsStyle = style;
        this.changeNotify();
    }

    public float getLinesBetweenPointsWidth() {
        return this.m_linesBetweenPointsWidth != 0.0f ? this.m_linesBetweenPointsWidth : 1.0E-4f;
    }

    public void setLinesBetweenPointsWidth(float width) {
        this.m_linesBetweenPointsWidth = width;
        this.changeNotify();
    }

    public int getDataPointStyle() {
        return this.m_dataPointStyle;
    }

    public void setDataPointStyle(int newValue) {
        this.m_dataPointStyle = newValue;
        this.changeNotify();
    }

    public int getDataPointSize() {
        return this.m_dataPointSize;
    }

    public void setDataPointSize(int newValue) {
        this.m_dataPointSize = newValue;
        this.changeNotify();
    }

    public Color getDataPointColor() {
        return this.m_dataPointColor;
    }

    public void setDataPointColor(Color nNewValue) {
        this.m_dataPointColor = nNewValue;
        this.changeNotify();
    }

    public Color getHistogramBarColor() {
        return this.m_histogramBarColor;
    }

    public void setHistogramBarColor(Color nNewValue) {
        this.m_histogramBarColor = nNewValue;
        this.changeNotify();
    }

    public Color getHistogramBarLineColor() {
        if (!this.histogramBarLineColorChanged && !this.getHistogramFill()) {
            return this.getHistogramBarColor();
        }
        return this.m_histogramBarLineColor;
    }

    public void setHistogramBarLineColor(Color nNewValue) {
        this.histogramBarLineColorChanged = true;
        this.m_histogramBarLineColor = nNewValue;
        this.changeNotify();
    }

    public int getHistogramBarLineStyle() {
        return this.m_histogramBarLineStyle;
    }

    public void setHistogramBarLineStyle(int style) {
        this.m_histogramBarLineStyle = style;
        this.changeNotify();
    }

    public float getHistogramBarLineWidth() {
        return this.m_histogramBarLineWidth != 0.0f ? this.m_histogramBarLineWidth : 1.0E-4f;
    }

    public void setHistogramBarLineWidth(float width) {
        this.m_histogramBarLineWidth = width;
        this.changeNotify();
    }

    public Color getLineColor() {
        return this.m_lineColor;
    }

    public void setLineColor(Color nNewValue) {
        this.m_lineColor = nNewValue;
        this.changeNotify();
    }

    public Color getErrorBarColor() {
        if (this.m_histogramFill && this.m_errorBarColorIsDefault) {
            return Color.black;
        }
        return this.m_errorBarColor;
    }

    public void setErrorBarColor(Color nNewValue) {
        this.m_errorBarColor = nNewValue;
        this.m_errorBarColorIsDefault = false;
        this.changeNotify();
    }

    public int getErrorBarStyle() {
        return this.m_errorBarStyle;
    }

    public void setErrorBarStyle(int style) {
        this.m_errorBarStyle = style;
        this.changeNotify();
    }

    public float getErrorBarDecoration() {
        return this.m_errorBarDecoration;
    }

    public void setErrorBarDecoration(float f) {
        this.m_errorBarDecoration = f;
        this.changeNotify();
    }

    public float getErrorBarWidth() {
        return this.m_errorBarWidth != 0.0f ? this.m_errorBarWidth : 1.0E-4f;
    }

    public void setErrorBarWidth(float width) {
        this.m_errorBarWidth = width;
        this.changeNotify();
    }

    public boolean getHistogramFill() {
        return this.m_histogramFill;
    }

    public void setHistogramFill(boolean bNewValue) {
        this.m_histogramFill = bNewValue;
        this.changeNotify();
    }

    protected void changeNotify() {
        super.changeNotify();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientData();
    }

    private void initTransientData() {
    }
}

