/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.PluginInfo;
import cytoscape.util.ZipUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class JarUtil {
    static final String MATCH_JAR_REGEXP = ".*\\.jar$";

    JarUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getPluginClass(String fileName, PluginInfo.FileType type) throws IOException {
        String pluginClassName = null;
        try {
            switch (type) {
                case JAR: {
                    JarFile jar = new JarFile(fileName);
                    try {
                        pluginClassName = JarUtil.getManifestAttribute(jar.getManifest());
                        Object var5_5 = null;
                        if (jar == null) return pluginClassName;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (jar == null) throw throwable;
                        jar.close();
                        throw throwable;
                    }
                    jar.close();
                    return pluginClassName;
                }
                case ZIP: {
                    List<ZipEntry> Entries = ZipUtil.getAllFiles(fileName, MATCH_JAR_REGEXP);
                    if (Entries.size() <= 0) {
                        String[] filePath = fileName.split("/");
                        fileName = filePath[filePath.length - 1];
                        throw new IOException(fileName + " does not contain any jar files or is not a zip file.");
                    }
                    ZipFile zf = null;
                    try {
                        zf = new ZipFile(fileName);
                        for (ZipEntry entry : Entries) {
                            Object var14_17;
                            String entryName = entry.getName();
                            InputStream is = null;
                            try {
                                Object var12_16;
                                JarInputStream jis = null;
                                is = ZipUtil.readFile(zf, entryName);
                                try {
                                    jis = new JarInputStream(is);
                                    pluginClassName = JarUtil.getManifestAttribute(jis.getManifest());
                                    var12_16 = null;
                                    if (jis != null) {
                                        jis.close();
                                    }
                                }
                                catch (Throwable throwable) {
                                    var12_16 = null;
                                    if (jis == null) throw throwable;
                                    jis.close();
                                    throw throwable;
                                }
                                var14_17 = null;
                                if (is == null) continue;
                                is.close();
                            }
                            catch (Throwable throwable) {
                                var14_17 = null;
                                if (is == null) throw throwable;
                                is.close();
                                throw throwable;
                            }
                        }
                        Object var16_20 = null;
                        if (zf == null) return pluginClassName;
                    }
                    catch (Throwable throwable) {
                        Object var16_21 = null;
                        if (zf == null) throw throwable;
                        zf.close();
                        throw throwable;
                    }
                    zf.close();
                    return pluginClassName;
                }
            }
            return pluginClassName;
        }
        catch (Exception e) {
            CyLogger.getLogger().debug("Problem getting plugin class name for " + fileName + " " + (Object)((Object)type), e);
            throw new IOException(e.toString());
        }
    }

    static String getManifestAttribute(Manifest m) {
        String value = null;
        if (m != null) {
            value = m.getMainAttributes().getValue("Cytoscape-Plugin");
        }
        return value;
    }
}

