/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.ShapeLayer;
import com.sun.glf.goodies.GradientPaintExt;
import com.sun.glf.goodies.RadialGradientPaint;
import com.sun.glf.util.CompositionFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

class RadialGradientPaintContext
implements PaintContext {
    static final int MAX_PRECISION = 256;
    static final float sqStep = 0.003937008f;
    static final float[] sqrtLut;
    static ColorModel xrgbmodel;
    Point2D.Float f1;
    Point2D.Float f2;
    float maInv;
    float e;
    double[] m;
    int[] gradient;
    WritableRaster working;
    ColorModel model;
    Rectangle bounds;
    boolean isCircular = false;
    float maxDistanceSq;

    public RadialGradientPaintContext(Rectangle2D.Float float_, Color color, Color color2, AffineTransform affineTransform) throws NoninvertibleTransformException {
        int n;
        float f = float_.width;
        float f2 = float_.height;
        float f3 = float_.x;
        float f4 = float_.y;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f > f2) {
            f5 = f / 2.0f;
            f6 = f2 / 2.0f;
        } else {
            f5 = f2 / 2.0f;
            f6 = f / 2.0f;
        }
        this.e = (float)Math.sqrt(1.0f - f6 * f6 / (f5 * f5));
        this.f1 = new Point2D.Float();
        this.f2 = new Point2D.Float();
        if (f > f2) {
            this.f1.x = f3 + f5 * (1.0f + this.e);
            this.f1.y = f4 + f6;
            this.f2.x = f3 + f5 * (1.0f - this.e);
            this.f2.y = f4 + f6;
        } else {
            this.f1.x = f3 + f6;
            this.f1.y = f4 + f5 * (1.0f + this.e);
            this.f2.x = f3 + f6;
            this.f2.y = f4 + f5 * (1.0f - this.e);
        }
        this.f1 = this.f1;
        this.f2 = this.f2;
        this.maInv = 1.0f / (2.0f * f5);
        boolean bl = this.isCircular = float_.width == float_.height;
        if (this.isCircular) {
            this.maInv = 1.0f / f5;
        }
        this.bounds = affineTransform.createTransformedShape(float_).getBounds();
        this.m = new double[6];
        AffineTransform affineTransform2 = affineTransform.createInverse();
        affineTransform2.getMatrix(this.m);
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        int n4 = n2 >> 24 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        int n8 = (n3 >> 24 & 0xFF) - n4;
        int n9 = (n3 >> 16 & 0xFF) - n5;
        int n10 = (n3 >> 8 & 0xFF) - n6;
        int n11 = (n3 & 0xFF) - n7;
        this.model = (n2 & n3) >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
        this.gradient = new int[256];
        int n12 = 0;
        for (n = 0; n <= 255; ++n) {
            float f7 = (float)n / 255.0f;
            this.gradient[n] = n12 = (int)((float)n4 + (float)n8 * f7) << 24 | (int)((float)n5 + (float)n9 * f7) << 16 | (int)((float)n6 + (float)n10 * f7) << 8 | (int)((float)n7 + (float)n11 * f7);
        }
        n = this.gradient.length - 1;
        this.maInv *= (float)n;
        Rectangle2D rectangle2D = affineTransform2.createTransformedShape(affineTransform.createTransformedShape(float_).getBounds()).getBounds2D();
        this.maxDistanceSq = (float)this.f1.distanceSq(rectangle2D.getX(), rectangle2D.getY());
        float f8 = (float)Math.sqrt(this.maxDistanceSq);
        this.maInv *= f8;
    }

    public void dispose() {
        this.working = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.working == null || this.working.getWidth() < n3 || this.working.getHeight() < n4) {
            this.working = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        }
        WritableRaster writableRaster = this.working;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = dataBufferInt.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        if (!this.isCircular) {
            this.fillRasterEllipse(nArray, n5, n7, n, n2, n3, n4);
        } else {
            this.fillRasterDisc(nArray, n5, n7, n, n2, n3, n4);
        }
        return writableRaster;
    }

    void fillRasterEllipse(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = this.bounds.x + this.bounds.width;
        int n9 = this.bounds.y + this.bounds.height;
        int n10 = n3 + n5;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        float f = 0.0f;
        int n14 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = (float)this.m[0];
        float f5 = (float)this.m[1];
        float f6 = (float)this.m[2];
        float f7 = (float)this.m[3];
        float f8 = (float)this.m[4];
        float f9 = (float)this.m[5];
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 1.0f - this.e;
        float f15 = this.gradient.length - 1;
        float f16 = this.e * f15;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        int n15 = 0;
        int n16 = 0;
        float f23 = 0.0f;
        for (int i = 0; i < n6; ++i) {
            n10 = n + n5;
            if (i + n4 < this.bounds.y || i + n4 > n9 || n3 + n5 < this.bounds.x || n3 > n8) {
                n7 = this.gradient[255];
                while (n < n10) {
                    nArray[n++] = n7;
                }
            } else {
                n13 = n;
                n7 = this.gradient[255];
                n11 = n + this.bounds.x - n3;
                n12 = n11 + this.bounds.width;
                int n17 = n12 = n12 > n10 ? n10 : n12;
                while (n < n11) {
                    nArray[n++] = n7;
                }
                n14 = n3 + n - n13;
                f2 = f4 * (float)n14 + f6 * (float)(n4 + i) + f8;
                f3 = f5 * (float)n14 + f7 * (float)(n4 + i) + f9;
                f10 = this.f1.x - f2;
                f11 = this.f1.y - f3;
                f12 = this.f2.x - f2;
                f13 = this.f2.y - f3;
                while (n < n12) {
                    f19 = (f10 * f10 + f11 * f11) / this.maxDistanceSq;
                    f20 = (f12 * f12 + f13 * f13) / this.maxDistanceSq;
                    if (f19 < 0.003937008f) {
                        f17 = (float)Math.sqrt(f19);
                    } else {
                        f21 = f19 / 0.003937008f;
                        n15 = (int)f21;
                        f23 = f21 - (float)n15;
                        f17 = f23 * sqrtLut[n15 + 1] + (1.0f - f23) * sqrtLut[n15];
                    }
                    if (f20 < 0.003937008f) {
                        f18 = (float)Math.sqrt(f20);
                    } else {
                        f22 = f20 / 0.003937008f;
                        n16 = (int)f22;
                        f23 = f22 - (float)n16;
                        f18 = f23 * sqrtLut[n16 + 1] + (1.0f - f23) * sqrtLut[n16];
                    }
                    f = (this.maInv * (f17 + f18) - f16) / f14;
                    f = f > f15 ? f15 : f;
                    f = f < 0.0f ? 0.0f : f;
                    nArray[n++] = this.gradient[(int)f];
                    f10 -= f4;
                    f12 -= f4;
                    f11 -= f5;
                    f13 -= f5;
                }
                n7 = this.gradient[255];
                while (n < n10) {
                    nArray[n++] = n7;
                }
            }
            n += n2;
        }
    }

    void fillRasterDisc(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = this.bounds.x + this.bounds.width;
        int n9 = this.bounds.y + this.bounds.height;
        int n10 = n3 + n5;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        float f = 0.0f;
        int n14 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = (float)this.m[0];
        float f5 = (float)this.m[1];
        float f6 = (float)this.m[2];
        float f7 = (float)this.m[3];
        float f8 = (float)this.m[4];
        float f9 = (float)this.m[5];
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = this.gradient.length - 1;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        int n15 = 0;
        float f16 = 0.0f;
        for (int i = 0; i < n6; ++i) {
            n10 = n + n5;
            if (i + n4 < this.bounds.y || i + n4 > n9 || n3 + n5 < this.bounds.x || n3 > n8) {
                n7 = this.gradient[(int)f12];
                while (n < n10) {
                    nArray[n++] = n7;
                }
            } else {
                n13 = n;
                n7 = this.gradient[(int)f12];
                n11 = n + this.bounds.x - n3;
                n12 = n11 + this.bounds.width;
                int n16 = n12 = n12 > n10 ? n10 : n12;
                while (n < n11) {
                    nArray[n++] = n7;
                }
                n14 = n3 + n - n13;
                f2 = f4 * (float)n14 + f6 * (float)(n4 + i) + f8;
                f3 = f5 * (float)n14 + f7 * (float)(n4 + i) + f9;
                f10 = this.f1.x - f2;
                f11 = this.f1.y - f3;
                while (n < n12) {
                    f14 = (f10 * f10 + f11 * f11) / this.maxDistanceSq;
                    if (f14 < 0.003937008f) {
                        f13 = (float)Math.sqrt(f14);
                    } else {
                        f15 = f14 / 0.003937008f;
                        n15 = (int)f15;
                        f16 = f15 - (float)n15;
                        f13 = f16 * sqrtLut[n15 + 1] + (1.0f - f16) * sqrtLut[n15];
                    }
                    f = this.maInv * f13;
                    f = f > f12 ? f12 : f;
                    f = f < 0.0f ? 0.0f : f;
                    nArray[n++] = this.gradient[(int)f];
                    f10 -= f4;
                    f11 -= f5;
                }
                n7 = this.gradient[(int)f12];
                while (n < n10) {
                    nArray[n++] = n7;
                }
            }
            n += n2;
        }
    }

    public static void main(String[] stringArray) {
        Rectangle rectangle = new Rectangle(0, 0, 1000, 500);
        Rectangle rectangle2 = new Rectangle(0, 0, 1000, 500);
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(rectangle, Color.white, Color.black);
        LayerComposition layerComposition = new LayerComposition(new Dimension(1000, 500));
        Layer[] layerArray = new Layer[3];
        for (int i = 0; i < layerArray.length / 3; ++i) {
            layerArray[3 * i + 2] = new ShapeLayer(layerComposition, rectangle2, new FillRenderer(radialGradientPaint));
            layerArray[3 * i + 1] = new ShapeLayer(layerComposition, rectangle2, new FillRenderer(new GradientPaint(0.0f, 0.0f, Color.white, rectangle.width, rectangle.height, Color.black)));
            layerArray[3 * i] = new ShapeLayer(layerComposition, rectangle2, new FillRenderer(new GradientPaintExt(0.0f, 0.0f, rectangle.width, rectangle.height, new float[]{1.0f, 1.0f}, new Color[]{Color.white, Color.blue, Color.black})));
        }
        layerComposition.setLayers(layerArray);
        CompositionFrame compositionFrame = new CompositionFrame("GradientPaintExtContext unit testing");
        compositionFrame.setComposition(layerComposition);
        compositionFrame.pack();
        compositionFrame.setVisible(true);
    }

    static {
        int n;
        sqrtLut = new float[256];
        for (n = 0; n < 255; ++n) {
            RadialGradientPaintContext.sqrtLut[n] = (float)Math.sqrt((float)n * 0.003937008f);
        }
        RadialGradientPaintContext.sqrtLut[n] = sqrtLut[n - 1];
        xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }
}

