/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnixJVMLocator {
    private static final String[] UNIX_ROOT_LOCATIONS = new String[]{"/opt/i4j_jres", "/usr/local/i4j_jres", new File(System.getProperty("user.home"), ".i4j_jres").getAbsolutePath(), "/usr/bin", "/usr", "/usr/java", "/usr/lib/java", "/usr/local", "/usr/lib", "/usr/jdk"};
    private static final String[] UNIX_DIR_KEYWORDS = new String[]{"java", "jre", "jdk", "j2sdk", "j2re", "j2jre"};
    public static final String[] JDK_FILES = new String[]{"bin/javac", "lib/tools.jar"};
    public static final String JAVA_EXECUTABLE = "bin/java";

    public static List getJVMLocations() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < UNIX_ROOT_LOCATIONS.length; ++i) {
            arrayList.addAll(UnixJVMLocator.searchRootLocation(UNIX_ROOT_LOCATIONS[i]));
        }
        return arrayList;
    }

    private static Collection searchRootLocation(String string) {
        ArrayList<JVMLocator.JVMLocation> arrayList = new ArrayList<JVMLocator.JVMLocation>();
        File[] fileArray = new File(string).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isDirectory()) continue;
                for (int j = 0; j < UNIX_DIR_KEYWORDS.length; ++j) {
                    if (file.getName().indexOf(UNIX_DIR_KEYWORDS[j]) <= -1) continue;
                    try {
                        JVMLocator.JVMLocation jVMLocation = JVMLocator.checkJVMLocation(file, JAVA_EXECUTABLE, JDK_FILES);
                        if (jVMLocation == null) continue;
                        arrayList.add(jVMLocation);
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        List list = UnixJVMLocator.getJVMLocations();
        for (int i = 0; i < list.size(); ++i) {
            JVMLocator.JVMLocation jVMLocation = (JVMLocator.JVMLocation)list.get(i);
            System.out.println(jVMLocation);
        }
    }
}

