## ----fragsfile, echo = FALSE, results = "asis"---------------------------
fragsfile <- system.file("extdata", "fragmentLists/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
data <- read.table(gzfile(fragsfile), header=FALSE,
    col.names=c("Chromosome Name", "Column 2", "Mid Point", "Hit Count",
    "Column 5"))
knitr::kable(head(data, n=6L), align = "crrrr", caption="FRAGSFILE")

## ----intersfile, echo=FALSE, results="asis"------------------------------
intersfile <- system.file("extdata", "contactCounts/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
data <- read.table(gzfile(intersfile), header=FALSE,
    col.names=c("Chromosome1 Name", "Mid Point 1", "Chromosome2 Name",
    "Mid Point 2", "Hit Count"))
knitr::kable(head(data, n=6L), align = "crcrr", caption="INTERSFILE")

## ---- eval=FALSE---------------------------------------------------------
#  library("FitHiC")
#  FitHiC(FRAGSFILE, INTERSFILE, OUTDIR, ...)

## ---- eval=FALSE---------------------------------------------------------
#  library("FitHiC")
#  FitHiC(FRAGSFILE, INTERSFILE, OUTDIR, ..., visual=TRUE)

## ---- eval=FALSE---------------------------------------------------------
#  library("FitHiC")
#  fragsfile <- system.file("extdata", "fragmentLists/Duan_yeast_EcoRI.gz",
#      package = "FitHiC")
#  intersfile <- system.file("extdata", "contactCounts/Duan_yeast_EcoRI.gz",
#      package = "FitHiC")
#  FitHiC(fragsfile, intersfile, getwd(), libname="Duan_yeast_EcoRI",
#      distUpThres=250000, distLowThres=10000)

## ----run, echo=FALSE, collapse=TRUE, warning=FALSE-----------------------
library("FitHiC")
fragsfile <- system.file("extdata", "fragmentLists/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
intersfile <- system.file("extdata", "contactCounts/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
FitHiC(fragsfile, intersfile, getwd(), libname="Duan_yeast_EcoRI",
    distUpThres=250000, distLowThres=10000)

## ----run-visual, echo=FALSE, message=FALSE, warning=FALSE, results="hide"----
library("FitHiC")
fragsfile <- system.file("extdata", "fragmentLists/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
intersfile <- system.file("extdata", "contactCounts/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
FitHiC(fragsfile, intersfile, getwd(), libname="Duan_yeast_EcoRI",
    distUpThres=250000, distLowThres=10000, visual=TRUE)

## ----calculate-probabilities, echo=FALSE, results="asis"-----------------
output <- file.path(getwd(), "Duan_yeast_EcoRI.fithic_pass1.txt")
data <- read.table(output, header=TRUE)
knitr::kable(head(data, n=6L), caption="Duan_yeast_EcoRI.fithic_pass1.txt")

output <- file.path(getwd(), "Duan_yeast_EcoRI.fithic_pass2.txt")
data <- read.table(output, header=TRUE)
knitr::kable(head(data, n=6L), caption="Duan_yeast_EcoRI.fithic_pass2.txt")

## ----fit-spline, echo=FALSE, results="asis"------------------------------
output <- file.path(getwd(),
    "Duan_yeast_EcoRI.spline_pass1.significances.txt.gz")
data <- read.table(gzfile(output), header=TRUE)
knitr::kable(head(data, n=6L), align="crcrrrr",
    caption="Duan_yeast_EcoRI.spline_pass1.significances.txt.gz")

output <- file.path(getwd(),
    "Duan_yeast_EcoRI.spline_pass2.significances.txt.gz")
data <- read.table(gzfile(output), header=TRUE)
knitr::kable(head(data, n=6L), align="crcrrrr",
    caption="Duan_yeast_EcoRI.spline_pass2.significances.txt.gz")

