## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()
library(ggplot2)

## ----echo=TRUE, eval=TRUE, message=FALSE---------------------------------
library(ClusterSignificance)

## ---- demoDataMlp--------------------------------------------------------
data(mlpMatrix)

## ----headMat, echo=FALSE, eval=TRUE--------------------------------------
##Mlp
groups <- rownames(mlpMatrix)
knitr::kable(
    mlpMatrix[1:3,], 
    digits = 2, 
    caption = "Head; Mlp matrix.", 
    align=c(rep('l', 2))
)

gTable <- as.data.frame(table(groups))
knitr::kable(
    gTable, 
    digits = 2, 
    align=c(rep('l', 2)), 
    caption = "Rownames table; Mlp matrix."
)

## ---- demoDataPcp--------------------------------------------------------
data(pcpMatrix)

## ----headPcp, echo=FALSE-------------------------------------------------
##Pcp
groups <- rownames(pcpMatrix)
knitr::kable(
    pcpMatrix[1:3,], 
    digits = 2, 
    caption = "Head; Pcp matrix.", 
    align=c(rep('l', 2))
)

gTable <- as.data.frame(table(groups))
knitr::kable(
    gTable, 
    digits = 2, 
    align=c(rep('l', 2)), 
    caption = "Rownames table; Pcp matrix."
)

## ---- fig.align='center', fig.width=10, fig.height=8---------------------
## Load demo input.
data(mlpMatrix)

## Create the group variable.
groups <- rownames(mlpMatrix)

## Run Mlp and plot.
prj <- mlp(mlpMatrix, groups)
plot(prj)

## ----classifyMlp, message=FALSE, fig.align='center', fig.width=8, fig.height=6----
## Classify and plot.
cl <- classify(prj)
plot(cl)

## ----permuteMlp, message=FALSE, fig.align='center', message = FALSE------
## Set the seed and number of iterations.
set.seed(3)
iterations <- 100 

## Permute and plot.
pe <- permute(
    mat=mlpMatrix, 
    iter=iterations, 
    groups=groups, 
    projmethod="mlp"
)

plot(pe)

## ----pValueMlp, echo=FALSE, eval=TRUE, message=FALSE---------------------
## p-value
pvalue(pe)

## ----PcpProjection, fig.align='center', fig.width=10, fig.height=10------
## Load demo input.
data(pcpMatrix)

## Create the group variable.
groups <- rownames(pcpMatrix)

## Run Pcp and plot.
prj <- pcp(pcpMatrix, groups)
plot(prj)

## ----classifyPcp, message=FALSE, fig.width=10, fig.height=7--------------
cl <- classify(prj)
plot(cl)

## ----permutePcp, message=FALSE, fig.width=10, fig.height=7---------------
#permute matrix
set.seed(3)
iterations <- 100 ## Set the number of iterations.

## Permute and plot.
pe <- permute(
    mat=pcpMatrix, 
    iter=iterations, 
    groups=groups, 
    projmethod="pcp"
)

plot(pe)

## ----pValuePcp, echo=TRUE, eval=TRUE, message=FALSE----------------------
pvalue(pe)

## ----echo=TRUE, eval=TRUE, message=FALSE---------------------------------
## The leukemia dataset is provided as a list with 3 elements. 
## An explaination of these can be found using the command:
## help(leukemia)

library(plsgenomics, quietly = TRUE)
data(leukemia)

## Extract the expression matrix.
expression <- leukemia$X 

## Run PCA and extract the principal components.
pca <- prcomp(expression, scale = TRUE)
mat <- pca$x

## Extract the grouping variable (coded as 1 (ALL) and 2 (AML)).
groups <- ifelse(leukemia$Y == 1, "ALL", "AML")

## ---- echo = FALSE-------------------------------------------------------
gTable <- as.data.frame(table(groups))
knitr::kable(gTable, 
    digits = 2, 
    align=c(rep('l', 2)), 
    caption = "Groups argument table."
)

## ----ALLprojection, fig.align='center', fig.width=10, fig.height=10------
ob <- pcp(mat, groups, normalize=TRUE)
plot(ob)

## ----ALLclassification, fig.align='center', fig.width=8, fig.height=6----
cl <- classify(ob)
plot(cl)

## ----ALLpermutation, fig.align='center', message = FALSE-----------------
set.seed(3)
iterations <- 100
pe <- permute(mat=mat, iter=iterations, groups=groups, projmethod="pcp")
pvalue(pe)

## ----concatPermuts, message=FALSE, eval=TRUE-----------------------------
mat <- mlpMatrix
groups <- rownames(mlpMatrix)
set.seed(3)
iterations <- 10

pe1 <- permute(mat=mat, iter=iterations, groups=groups, projmethod="pcp")
pe2 <- permute(mat=mat, iter=iterations, groups=groups, projmethod="pcp")
pe3 <- permute(mat=mat, iter=iterations, groups=groups, projmethod="pcp")
pvalue(pe1)

pe <- c(pe1, pe2, pe3)
pvalue(pe)

## ----userDefinedPermats, eval=TRUE---------------------------------------
##define permMatrix function
.pca <- function(y, groups, uniq.groups, mat) {
    pca <- prcomp(
        sapply(1:ncol(mat[groups %in% uniq.groups[, y], ]), 
            function(i)
                mat[groups %in% uniq.groups[, y], i] <- 
                    sample(
                        mat[groups %in% uniq.groups[, y], i], 
                        replace=FALSE
                    )
        ), scale=TRUE
    )
    return(pca$x)
}

permMatrix <- function(iterations, groups, mat) {
    uniq.groups <- combn(unique(groups), 2)
    permats <- lapply(1:ncol(uniq.groups), 
        function(y)
            lapply(1:iterations, 
                function(x)
                    .pca(y, groups, uniq.groups, mat)
            )
    )
    return(permats)
}

set.seed(3)
mat <- pcpMatrix
groups <- rownames(pcpMatrix)
iterations = 100
permats <- permMatrix(iterations, groups, mat)

## ----runUserDefinedMatrix, eval=FALSE------------------------------------
#  pe <- permute(
#      mat = mat,
#      iter=100,
#      groups=groups,
#      projmethod="pcp",
#      userPermats=permats
#  )

## ----echo=TRUE, eval=TRUE------------------------------------------------
sessionInfo()

