/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridgedb.AbstractIDMapperCapabilities;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.impl.InternalUtils;
import org.bridgedb.rdb.SimpleGdb;

public abstract class SimpleGdbImplCommon
extends SimpleGdb {
    final SimpleGdb.QueryLifeCycle qDatasources = new SimpleGdb.QueryLifeCycle("SELECT codeRight FROM link GROUP BY codeRight");
    final SimpleGdb.QueryLifeCycle qInfo = new SimpleGdb.QueryLifeCycle("SELECT * FROM info");
    final SimpleGdb.QueryLifeCycle qXrefExists = new SimpleGdb.QueryLifeCycle("SELECT id FROM datanode WHERE id = ? AND code = ?");
    final SimpleGdb.QueryLifeCycle qAttribute = new SimpleGdb.QueryLifeCycle("SELECT attrvalue FROM attribute  WHERE id = ? AND code = ? AND attrname = ?");
    final SimpleGdb.QueryLifeCycle qAllAttributes = new SimpleGdb.QueryLifeCycle("SELECT attrname, attrvalue FROM attribute  WHERE id = ? AND code = ?");
    final SimpleGdb.QueryLifeCycle qAttributesSet = new SimpleGdb.QueryLifeCycle("SELECT attrname FROM attribute GROUP BY attrname");
    final SimpleGdb.QueryLifeCycle qCrossRefs = new SimpleGdb.QueryLifeCycle("SELECT dest.idRight, dest.codeRight FROM link AS src JOIN link AS dest ON src.idLeft = dest.idLeft and src.codeLeft = dest.codeLeft WHERE src.idRight = ? AND src.codeRight = ?");
    final SimpleGdb.QueryLifeCycle qCrossRefsWithCode = new SimpleGdb.QueryLifeCycle("SELECT dest.idRight, dest.codeRight FROM link AS src JOIN link AS dest ON src.idLeft = dest.idLeft and src.codeLeft = dest.codeLeft WHERE src.idRight = ? AND src.codeRight = ? AND dest.codeRight = ?");
    final SimpleGdb.QueryLifeCycle qRefsByAttribute = new SimpleGdb.QueryLifeCycle("SELECT datanode.id, datanode.code FROM datanode  LEFT JOIN attribute ON attribute.code = datanode.code AND attribute.id = datanode.id WHERE attrName = ? AND attrValue = ?");
    final SimpleGdb.QueryLifeCycle qFreeSearch = new SimpleGdb.QueryLifeCycle("SELECT id, code FROM datanode WHERE LOWER(ID) LIKE ?");
    final SimpleGdb.QueryLifeCycle qAttributeSearch = new SimpleGdb.QueryLifeCycle("SELECT id, code, attrvalue FROM attribute WHERE attrname = ? AND LOWER(attrvalue) LIKE ?");
    final SimpleGdb.QueryLifeCycle qIdSearchWithAttributes = new SimpleGdb.QueryLifeCycle("SELECT id, code, attrvalue FROM attribute WHERE attrname = ? AND LOWER(ID) LIKE ?");
    final SimpleGdb.QueryLifeCycle qAllXrefs = new SimpleGdb.QueryLifeCycle("SELECT id, code FROM datanode");
    final SimpleGdb.QueryLifeCycle qAllXrefsByDatasource = new SimpleGdb.QueryLifeCycle("SELECT id, code FROM datanode WHERE code = ?");
    private final IDMapperCapabilities caps = new SimpleGdbCapabilities();

    SimpleGdbImplCommon(String dbName, String connectionString) throws IDMapperException {
        super(dbName, connectionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean xrefExists(Xref xref) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        if (xref.getDataSource() == null) {
            return false;
        }
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qXrefExists;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, xref.getId());
                pst.setString(2, xref.getDataSource().getSystemCode());
                ResultSet r = pst.executeQuery();
                if (r.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getInfo() throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashMap<String, String> result = new HashMap<String, String>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qInfo;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        String key = rsmd.getColumnName(i);
                        String val = rs.getString(i);
                        result.put(key, val);
                    }
                }
            }
            catch (SQLException ex) {
                throw new IDMapperException(ex);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Xref> mapID(Xref idc, DataSource ... resultDs) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst = resultDs.length != 1 ? this.qCrossRefs : this.qCrossRefsWithCode;
        HashSet<Xref> refs = new HashSet<Xref>();
        if (idc.getDataSource() == null) {
            return refs;
        }
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, idc.getId());
                pst.setString(2, idc.getDataSource().getSystemCode());
                if (resultDs.length == 1) {
                    pst.setString(3, resultDs[0].getSystemCode());
                }
                HashSet<DataSource> dsFilter = new HashSet<DataSource>(Arrays.asList(resultDs));
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    DataSource ds = DataSource.getExistingBySystemCode(rs.getString(2));
                    if (resultDs.length != 0 && !dsFilter.contains(ds)) continue;
                    refs.add(new Xref(rs.getString(1), ds));
                }
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
            return refs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Xref> getCrossRefsByAttribute(String attrName, String attrValue) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        ArrayList<Xref> refs = new ArrayList<Xref>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qRefsByAttribute;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, attrName);
                pst.setString(2, attrValue);
                ResultSet r = pst.executeQuery();
                while (r.next()) {
                    Xref ref = new Xref(r.getString(1), DataSource.getExistingBySystemCode(r.getString(2)));
                    refs.add(ref);
                }
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
            return refs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Xref> freeSearch(String text, int limit) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<Xref> result = new HashSet<Xref>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qFreeSearch;
        synchronized (queryLifeCycle) {
            try {
                pst.init(limit);
                pst.setString(1, "%" + text.toLowerCase() + "%");
                ResultSet r = pst.executeQuery();
                while (r.next()) {
                    String id = r.getString(1);
                    DataSource ds = DataSource.getExistingBySystemCode(r.getString(2));
                    Xref ref = new Xref(id, ds);
                    result.add(ref);
                }
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DataSource> getDataSources() throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<DataSource> result = new HashSet<DataSource>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qDatasources;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    DataSource ds = DataSource.getExistingBySystemCode(rs.getString(1));
                    result.add(ds);
                }
            }
            catch (SQLException ignore) {
                throw new IDMapperException(ignore);
            }
            finally {
                pst.cleanup();
            }
            return result;
        }
    }

    @Override
    public IDMapperCapabilities getCapabilities() {
        return this.caps;
    }

    @Override
    public boolean isFreeAttributeSearchSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Xref, String> freeAttributeSearch(String query, String attrType, int limit) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashMap<Xref, String> result = new HashMap<Xref, String>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = "org.bridgedb.MATCH_ID".equals(attrType) ? this.qIdSearchWithAttributes : this.qAttributeSearch;
        synchronized (queryLifeCycle) {
            try {
                pst.init(limit);
                pst.setString(1, attrType);
                pst.setString(2, "%" + query.toLowerCase() + "%");
                ResultSet r = pst.executeQuery();
                while (r.next()) {
                    String id = r.getString("id");
                    String code = r.getString("code");
                    String symbol = r.getString("attrValue");
                    result.put(new Xref(id, DataSource.getExistingBySystemCode(code)), symbol);
                }
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Xref, Set<String>> freeAttributeSearchEx(String query, String attrType, int limit) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashMap<Xref, Set<String>> result = new HashMap<Xref, Set<String>>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = "org.bridgedb.MATCH_ID".equals(attrType) ? this.qIdSearchWithAttributes : this.qAttributeSearch;
        synchronized (queryLifeCycle) {
            try {
                pst.init(limit);
                pst.setString(1, attrType);
                pst.setString(2, "%" + query.toLowerCase() + "%");
                ResultSet r = pst.executeQuery();
                while (r.next()) {
                    String id = r.getString("id");
                    String code = r.getString("code");
                    String symbol = r.getString("attrValue");
                    Xref ref = new Xref(id, DataSource.getExistingBySystemCode(code));
                    InternalUtils.multiMapPut(result, ref, symbol);
                }
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAttributeSet() throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<String> result = new HashSet<String>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAttributesSet;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (SQLException ignore) {
                throw new IDMapperException(ignore);
            }
            finally {
                pst.cleanup();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Xref> getIterator() throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<Xref> xrefs = new HashSet<Xref>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAllXrefs;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    xrefs.add(new Xref(rs.getString(1), DataSource.getExistingBySystemCode(rs.getString(2))));
                }
            }
            catch (SQLException ignore) {
                throw new IDMapperException(ignore);
            }
            finally {
                pst.cleanup();
            }
            return xrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Xref> getIterator(DataSource ds) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<Xref> xrefs = new HashSet<Xref>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAllXrefsByDatasource;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ds.getSystemCode());
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    xrefs.add(new Xref(rs.getString(1), ds));
                }
            }
            catch (SQLException ignore) {
                throw new IDMapperException(ignore);
            }
            finally {
                pst.cleanup();
            }
            return xrefs;
        }
    }

    class SimpleGdbCapabilities
    extends AbstractIDMapperCapabilities {
        public SimpleGdbCapabilities() throws IDMapperException {
            super(SimpleGdbImplCommon.this.getDataSources(), true, SimpleGdbImplCommon.this.getInfo());
        }
    }
}

