/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.bio.DataSourceTxt;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTxtTest {
    @Test
    public void testUniqueSystemCodes() {
        DataSourceTxt.init();
        HashSet<String> codes = new HashSet<String>();
        Set<DataSource> sources = DataSource.getDataSources();
        Assert.assertNotSame((Object)0, (Object)sources.size());
        for (DataSource source : sources) {
            codes.add(source.getSystemCode());
        }
        Assert.assertEquals((long)sources.size(), (long)codes.size());
    }

    @Test
    public void systemCodesDoNotHaveWhitespace() {
        DataSourceTxt.init();
        Set<DataSource> sources = DataSource.getDataSources();
        Assert.assertNotSame((Object)0, (Object)sources.size());
        for (DataSource source : sources) {
            String sysCode = source.getSystemCode();
            if (sysCode == null) continue;
            Assert.assertEquals((long)sysCode.length(), (long)sysCode.trim().length());
            Assert.assertFalse((boolean)sysCode.contains(" "));
        }
    }

    @Test
    public void testWriteRead() throws IOException {
        System.out.println("WriteRead");
        DataSourceTxt.init();
        File generated = new File("test-data/generatedDatasources.txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(generated));
        FileInputStream is = new FileInputStream(generated);
        DataSourceTxt.loadInputStream(is);
    }

    @Test
    public void testWikidata() throws Exception {
        DataSourceTxt.init();
        DataSource wikidata = DataSource.getExistingByFullName("Wikidata");
        Assert.assertNotNull((Object)wikidata);
        Assert.assertTrue((boolean)wikidata.urlPatternKnown());
        Assert.assertEquals((Object)"Wd", (Object)wikidata.getSystemCode());
    }
}

