/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.bridgedb.Xref;
import org.junit.Assert;
import org.junit.Test;

public class XrefTest {
    private final DataSource EN = DataSource.register("En", "Ensembl").asDataSource();
    private final DataSource UNIPROT = DataSource.register("S", "Uniprot-TrEMBL").urnBase("urn:miriam:uniprot:").asDataSource();

    @Test
    public void testConstructor() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Assert.assertNotNull((Object)xref);
        Assert.assertEquals((Object)"ENSG000001", (Object)xref.getId());
        Assert.assertNotNull((Object)xref.getDataSource());
        Assert.assertEquals((Object)"En", (Object)xref.getDataSource().getSystemCode());
    }

    @Test
    public void testEquals_Null() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Assert.assertFalse((boolean)xref.equals(null));
    }

    @Test
    public void testEquals_NonXref() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Assert.assertFalse((boolean)xref.equals("ENSG000001"));
    }

    @Test
    public void testEquals_DiffId() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Xref xref2 = new Xref("ENSG000002", this.EN);
        Assert.assertFalse((boolean)xref.equals(xref2));
        Assert.assertFalse((boolean)xref2.equals(xref));
    }

    @Test
    public void testEquals() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Xref xref2 = new Xref("ENSG000001", this.EN);
        Assert.assertTrue((boolean)xref.equals(xref2));
        Assert.assertTrue((boolean)xref2.equals(xref));
    }

    @Test
    public void testCompareTo() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Xref xref2 = new Xref("ENSG000001", this.EN);
        Assert.assertEquals((long)0L, (long)xref.compareTo(xref2));
        Assert.assertEquals((long)0L, (long)xref2.compareTo(xref));
    }

    @Test
    public void testCompareTo_Diff() {
        Xref xref = new Xref("ENSG000001", this.EN);
        Xref xref2 = new Xref("ENSG000002", this.EN);
        Assert.assertNotSame((Object)0, (Object)xref.compareTo(xref2));
        Assert.assertNotSame((Object)0, (Object)xref2.compareTo(xref));
    }

    @Test
    public void testURNRoundtripping() {
        Xref xref = new Xref("P12345", this.UNIPROT);
        String urn = xref.getURN();
        Assert.assertNotNull((Object)urn);
        Assert.assertNotSame((Object)0, (Object)urn.length());
        Xref xref2 = Xref.fromUrn(urn);
        Assert.assertTrue((boolean)xref.equals(xref2));
        Assert.assertTrue((boolean)xref2.equals(xref));
    }
}

