/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;

public class IDMapperStackTest
extends TestCase {
    public static Map<String, IDMapper> mappers;
    public static final String[] FILENAMES;
    private static IDMapperStack stack;
    private static DataSource dsW;
    private static DataSource dsX;
    private static DataSource dsY;
    private static DataSource dsZ;
    private static DataSource dsA;
    private static DataSource dsE;
    private static DataSource dsB;
    private static DataSource dsC;
    private static DataSource dsD;

    protected void setUp() throws ClassNotFoundException, IDMapperException, MalformedURLException {
        Class.forName("org.bridgedb.file.IDMapperText");
        mappers = new HashMap<String, IDMapper>();
        stack = new IDMapperStack();
        stack.setTransitive(true);
        for (String fileName : FILENAMES) {
            String fullName = fileName + ".csv";
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            URL url = classLoader.getResource(fullName);
            IDMapperStackTest.assertNotNull((String)("Could not find resource in classpath: " + fullName), (Object)url);
            IDMapper m = BridgeDb.connect("idmapper-text:" + url);
            mappers.put(fileName, m);
            stack.addIDMapper(m);
        }
        dsW = DataSource.getByFullName("W");
        dsX = DataSource.getByFullName("X");
        dsY = DataSource.getByFullName("Y");
        dsZ = DataSource.getByFullName("Z");
        dsA = DataSource.getByFullName("A");
        dsB = DataSource.getByFullName("B");
        dsC = DataSource.getByFullName("C");
        dsD = DataSource.getByFullName("D");
        dsE = DataSource.getByFullName("E");
    }

    public void testMapIDXrefDataSourceArray() throws IDMapperException {
        Xref src = new Xref("e1", dsE);
        Set<Xref> results = stack.mapID(src, new DataSource[0]);
        System.out.println("src Xref: " + src);
        IDMapperStackTest.assertEquals((int)4, (int)results.size());
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("a1", dsA)));
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("b1", dsB)));
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("c1", dsC)));
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("d1", dsD)));
        IDMapperStackTest.assertTrue((boolean)true);
    }

    public void testSimpleMapID() throws IDMapperException {
        Xref src = new Xref("x1", dsX);
        Set<Xref> results = stack.getIDMapperAt(0).mapID(src, dsY);
        System.out.println("single IDMapper");
        System.out.println("src Xref: " + src);
        System.out.println("src.dataSource: " + src.getDataSource());
        System.out.println("results.size(): " + results.size());
        for (Xref x : results) {
            System.out.println(x);
        }
    }

    public void testMapID_A_to_E() throws IDMapperException {
        Xref src = new Xref("a1", dsA);
        Set<Xref> results = stack.mapID(src, dsE);
        System.out.println("results.size(): " + results.size());
        for (Xref x : results) {
            System.out.println(x);
        }
        IDMapperStackTest.assertEquals((int)1, (int)results.size());
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("e1", dsE)));
    }

    public void testMapID_X_W_via_Y() throws IDMapperException {
        Xref src = new Xref("x2", dsX);
        Set<Xref> results = stack.mapID(src, dsW);
        IDMapperStackTest.assertEquals((int)1, (int)results.size());
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("w2", dsW)));
    }

    public void testMapID_all() throws IDMapperException {
        Xref src = new Xref("x2", dsX);
        Set<Xref> results = stack.mapID(src, new DataSource[0]);
        System.out.println("RESULTS");
        for (Xref ref : results) {
            System.out.println(ref);
        }
        IDMapperStackTest.assertEquals((int)3, (int)results.size());
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("y2", dsY)));
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("z2", dsZ)));
        IDMapperStackTest.assertTrue((boolean)results.contains(new Xref("w2", dsW)));
    }

    static {
        FILENAMES = new String[]{"AB", "BC", "CD", "DE", "XY", "XZ", "YW", "YZ"};
    }
}

