## ----loadLibs------------------------------------------------------------
library(BiocWorkflowTools)

## ----exampleFile---------------------------------------------------------
example_Rmd <- system.file('examples/f1000_software_example.Rmd', package = "BiocWorkflowTools")
example_Rmd

## ----createTmpDir, message=FALSE, eval=TRUE------------------------------
tmp_dir <- file.path(tempdir(), 'F1000_example')
dir.create(tmp_dir)

## ----convertToLatex, message=FALSE, eval=FALSE---------------------------
#  markdownToLatex(input = example_Rmd, output = tmp_dir, compress = TRUE)

## ----upload, eval=FALSE--------------------------------------------------
#  zip_file <- paste0(tmp_dir, '.zip')
#  uploadToOverleaf(files = zip_file, openInBrowser = TRUE)

## ----sessionInfo, eval=TRUE----------------------------------------------
sessionInfo()

