/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import weka.classifiers.CostMatrix;
import weka.gui.ExtensionFileFilter;

public class CostMatrixEditor
implements PropertyEditor {
    private CostMatrix m_matrix;
    private PropertyChangeSupport m_propSupport;
    private CustomEditor m_customEditor;
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    static /* synthetic */ Class class$java$lang$Double;

    public CostMatrixEditor() {
        this.m_matrix = new CostMatrix(2);
        this.m_propSupport = new PropertyChangeSupport(this);
        this.m_customEditor = new CustomEditor();
    }

    public void setValue(Object object) {
        this.m_matrix = (CostMatrix)object;
        this.m_customEditor.matrixChanged();
    }

    public Object getValue() {
        return this.m_matrix;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.drawString(this.m_matrix.size() + " x " + this.m_matrix.size() + " cost matrix", rectangle.x, rectangle.y + rectangle.height);
    }

    public String getJavaInitializationString() {
        return "new CostMatrix(" + this.m_matrix.size() + ")";
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
        throw new IllegalArgumentException("CostMatrixEditor: CostMatrix properties cannot be expressed as text");
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this.m_customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    TableModelListener {
        private CostMatrixTableModel m_tableModel;
        private JButton m_defaultButton;
        private JButton m_openButton;
        private JButton m_saveButton;
        private JTextField m_classesField;

        public CustomEditor() {
            CostMatrixEditor.this.m_fileChooser.setFileFilter(new ExtensionFileFilter(CostMatrix.FILE_EXTENSION, "Cost files"));
            CostMatrixEditor.this.m_fileChooser.setFileSelectionMode(0);
            this.m_defaultButton = new JButton("Defaults");
            this.m_openButton = new JButton("Open...");
            this.m_saveButton = new JButton("Save...");
            this.m_classesField = new JTextField("" + CostMatrixEditor.this.m_matrix.size());
            this.m_defaultButton.addActionListener(this);
            this.m_openButton.addActionListener(this);
            this.m_saveButton.addActionListener(this);
            this.m_classesField.addActionListener(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 2, 0, 0));
            jPanel.add(new JLabel("Classes:", 4));
            jPanel.add(this.m_classesField);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.insets = new Insets(2, 10, 2, 10);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.m_defaultButton, gridBagConstraints);
            jPanel2.add(this.m_defaultButton);
            gridBagLayout.setConstraints(this.m_openButton, gridBagConstraints);
            jPanel2.add(this.m_openButton);
            gridBagLayout.setConstraints(this.m_saveButton, gridBagConstraints);
            jPanel2.add(this.m_saveButton);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            jPanel2.add(jPanel);
            JPanel jPanel3 = new JPanel();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel2.add(jPanel3);
            this.m_tableModel = new CostMatrixTableModel();
            this.m_tableModel.addTableModelListener(this);
            JTable jTable = new JTable(this.m_tableModel);
            this.setLayout(new BorderLayout());
            this.add((Component)jTable, "Center");
            this.add((Component)jPanel2, "East");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.m_defaultButton) {
                CostMatrixEditor.this.m_matrix.initialize();
                this.matrixChanged();
            } else if (actionEvent.getSource() == this.m_openButton) {
                this.openMatrix();
            } else if (actionEvent.getSource() == this.m_saveButton) {
                this.saveMatrix();
            } else if (actionEvent.getSource() == this.m_classesField) {
                try {
                    int n = Integer.parseInt(this.m_classesField.getText());
                    if (n > 0 && n != CostMatrixEditor.this.m_matrix.size()) {
                        CostMatrixEditor.this.setValue(new CostMatrix(n));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            CostMatrixEditor.this.m_propSupport.firePropertyChange(null, null, null);
        }

        public void matrixChanged() {
            this.m_tableModel.fireTableStructureChanged();
            this.m_classesField.setText("" + CostMatrixEditor.this.m_matrix.size());
        }

        private void openMatrix() {
            int n = CostMatrixEditor.this.m_fileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = CostMatrixEditor.this.m_fileChooser.getSelectedFile();
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    CostMatrixEditor.this.m_matrix = new CostMatrix(bufferedReader);
                    ((Reader)bufferedReader).close();
                    this.matrixChanged();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Error reading file '" + file.getName() + "':\n" + exception.getMessage(), "Load failed", 0);
                    System.out.println(exception.getMessage());
                }
            }
        }

        private void saveMatrix() {
            int n = CostMatrixEditor.this.m_fileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = CostMatrixEditor.this.m_fileChooser.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(CostMatrix.FILE_EXTENSION)) {
                    file = new File(file.getParent(), file.getName() + CostMatrix.FILE_EXTENSION);
                }
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    CostMatrixEditor.this.m_matrix.write(bufferedWriter);
                    ((Writer)bufferedWriter).close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Error writing file '" + file.getName() + "':\n" + exception.getMessage(), "Save failed", 0);
                    System.out.println(exception.getMessage());
                }
            }
        }
    }

    private class CostMatrixTableModel
    extends AbstractTableModel {
        private CostMatrixTableModel() {
        }

        public int getRowCount() {
            return CostMatrixEditor.this.m_matrix.size();
        }

        public int getColumnCount() {
            return CostMatrixEditor.this.m_matrix.size();
        }

        public Object getValueAt(int n, int n2) {
            return new Double(CostMatrixEditor.this.m_matrix.getElement(n, n2));
        }

        public void setValueAt(Object object, int n, int n2) {
            double d = (Double)object;
            CostMatrixEditor.this.m_matrix.setElement(n, n2, d);
            this.fireTableCellUpdated(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$Double == null ? (class$java$lang$Double = CostMatrixEditor.class$("java.lang.Double")) : class$java$lang$Double;
        }
    }
}

