### R code from vignette source 'ABSSeq.Rnw'

###################################################
### code chunk number 1: ABSSeq.Rnw:27-28
###################################################
library(ABSSeq)


###################################################
### code chunk number 2: ABSSeq.Rnw:33-35
###################################################
data(simuN5)
names(simuN5)


###################################################
### code chunk number 3: ABSSeq.Rnw:40-41
###################################################
simuN5$groups


###################################################
### code chunk number 4: ABSSeq.Rnw:46-47
###################################################
conditions <- factor(c(rep(1,5),rep(2,5)))


###################################################
### code chunk number 5: ABSSeq.Rnw:52-55
###################################################
obj <- ABSDataSet(simuN5$counts, factor(simuN5$groups))
obj1 <- ABSDataSet(simuN5$counts, conditions)
pairedobj <- ABSDataSet(simuN5$counts, conditions,paired=TRUE)


###################################################
### code chunk number 6: ABSSeq.Rnw:60-64
###################################################
obj1 <- ABSDataSet(simuN5$counts, factor(simuN5$groups),normMethod="user",sizeFactor=runif(10,1,2))
normMethod(obj1)
normMethod(obj1) <- "geometric"
normMethod(obj1)


###################################################
### code chunk number 7: ABSSeq.Rnw:69-71
###################################################
  obj=normalFactors(obj)
  sFactors(obj)


###################################################
### code chunk number 8: ABSSeq.Rnw:76-77
###################################################
  head(counts(obj,norm=TRUE))


###################################################
### code chunk number 9: ABSSeq.Rnw:82-83
###################################################
  obj=callParameter(obj)


###################################################
### code chunk number 10: plotDifftoBase
###################################################
obj <- callDEs(obj)
plotDifftoBase(obj)


###################################################
### code chunk number 11: plotDifftoBase
###################################################
obj <- callDEs(obj)
plotDifftoBase(obj)


###################################################
### code chunk number 12: ABSSeq.Rnw:105-107
###################################################
obj <- callDEs(obj)
head(results(obj,c("rawFC","lowFC","foldChange","pvalue","adj.pvalue")))


###################################################
### code chunk number 13: ABSSeq.Rnw:112-113
###################################################
head(results(obj))


###################################################
### code chunk number 14: ABSSeq.Rnw:118-123
###################################################
data(simuN5)
obj <- ABSDataSet(simuN5$counts, factor(simuN5$groups))
obj <- ABSSeq(obj)
res=results(obj,c("Amean","Bmean","foldChange","pvalue","adj.pvalue"))
head(res)


###################################################
### code chunk number 15: ABSSeq.Rnw:128-136
###################################################
data(simuN5)
obj <- ABSDataSet(simuN5$counts, factor(simuN5$groups),minRates=0.2, maxRates=0.2)
#or by slot functions
#minRates(obj) <- 0.2
#maxRates(obj) <- 0.2
obj <- ABSSeq(obj)
res=results(obj,c("Amean","Bmean","foldChange","pvalue","adj.pvalue"))
head(res)


###################################################
### code chunk number 16: ABSSeq.Rnw:140-147
###################################################
data(simuN5)
obj <- ABSDataSet(simuN5$counts, factor(simuN5$groups),minDispersion=0.1)
#or by slot functions
#minimalDispersion(obj) <- 0.2
obj <- ABSSeq(obj)
res=results(obj,c("Amean","Bmean","foldChange","pvalue","adj.pvalue"))
head(res)


###################################################
### code chunk number 17: ABSSeq.Rnw:152-157
###################################################
data(simuN5)
obj <- ABSDataSet(simuN5$counts[,c(1,2)], factor(c(1,2)))
obj <- ABSSeq(obj)
res=results(obj,c("Amean","Bmean","foldChange","pvalue","adj.pvalue"))
head(res)


###################################################
### code chunk number 18: ABSSeq.Rnw:164-169
###################################################
data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- ABSSeq(obj, useaFold=TRUE)
res=results(obj,c("Amean","Bmean","foldChange","pvalue","adj.pvalue"))
head(res)


