## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")
library(devtools)
load_all("./")

## ----eval = FALSE,message=FALSE-----------------------------------------------
#  #To install this package, start R (version "3.6" or later) and enter:
#    #if (!requireNamespace("BiocManager", quietly = TRUE))
#    #  install.packages("BiocManager")
#    #
#    #BiocManager::install("spiky")
#  
#  library(spiky)

## ----eval=TRUE----------------------------------------------------------------
spike_path <- system.file("data", "spike.rda", package = "spiky")
load(spike_path)
#Load in your bam file using scan_spiked_bam
#ssb_res <- scan_spiked_bam("bam/file/path",spike=spike)
#Example result
ssb_res_path <- system.file("data", "ssb_res.rda", package = "spiky")
load(ssb_res_path)

## ----eval=TRUE----------------------------------------------------------------
##Calculate methylation specificity
methyl_spec <- methylation_specificity(ssb_res,spike=spike)
print(methyl_spec)

## ----eval=TRUE----------------------------------------------------------------
## Build the Gaussian generalized linear model on the spike-in control data
gaussian_glm <- model_glm_pmol(covg_to_df(ssb_res,spike=spike),spike=spike)
summary(gaussian_glm)

## ----eval=TRUE----------------------------------------------------------------
# Predict pmol concentration
# To select a genome other than hg38, use BSgenome::available.packages() to find valid BSgenome name
#library("BSgenome.Hsapiens.UCSC.hg38")
sample_data_pmol <- predict_pmol(gaussian_glm, ssb_res,bsgenome="BSgenome.Hsapiens.UCSC.hg38",ret="df")
head(sample_data_pmol,n=1)


## ----eval=TRUE----------------------------------------------------------------
sample_binned_data <- bin_pmol(sample_data_pmol)
head(sample_binned_data,n=1)

