params <-
list(test = FALSE)

## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(BiocStyle)

## ----warning=FALSE, message=FALSE---------------------------------------------
# load required packages
library(spicyR)
library(ggplot2)

## ---- eval = FALSE------------------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  BiocManager::install("spicyR")

## -----------------------------------------------------------------------------
data("diabetesData")
diabetesData
cellSummary(diabetesData)
imagePheno(diabetesData)

## ----message=FALSE------------------------------------------------------------
spicyTestPair <- spicy(diabetesData, 
                       condition = "stage", 
                       subject = "case", 
                       from = "beta", 
                       to = "delta")

topPairs(spicyTestPair)

## ----eval=FALSE---------------------------------------------------------------
#  spicyTest <- spicy(diabetesData,
#                     condition = "stage",
#                     subject = "case")

## -----------------------------------------------------------------------------
data("spicyTest")

## -----------------------------------------------------------------------------
spicyTest
topPairs(spicyTest)  

## -----------------------------------------------------------------------------
signifPlot(spicyTest, 
           breaks=c(-3, 3, 0.5),
           marksToPlot = c("alpha", "beta", "gamma", "delta", 
                           "B", "naiveTc", "Th", "Tc", "neutrophil", "macrophage"))

## -----------------------------------------------------------------------------
sessionInfo()

