## ----inf1, echo=FALSE, message=FALSE------------------------------------------
library(sesame)
sesameDataCache()
sdf = sesameDataGet('EPIC.1.SigDF')

## ----inf2, message=FALSE------------------------------------------------------
sdf = sesameDataGet('EPIC.1.SigDF')
inferSex(sdf)
inferSexKaryotypes(sdf)

## ----nh16, message=FALSE------------------------------------------------------
sdf = sesameDataGet("MM285.1.SigDF")
inferSex(sdf)

## ----inf3---------------------------------------------------------------------
sdf = sesameDataGet('EPIC.1.SigDF')
inferEthnicity(sdf)

## ----inf4---------------------------------------------------------------------
betas <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
predictAgeHorvath353(betas)

## ----inf18, message=FALSE-----------------------------------------------------
library(SummarizedExperiment)
betas = assay(sesameDataGet("MM285.10.SE.tissue"))

## ----nh19---------------------------------------------------------------------
predictMouseAgeInMonth(betas[,1])

## ----inf7, message=FALSE------------------------------------------------------
betas.tissue <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
estimateLeukocyte(betas.tissue)

## ----inf8, message=FALSE, warning=FALSE, include=FALSE------------------------
library(sesame)
sesameDataCacheAll()

## ----inf9, eval=FALSE---------------------------------------------------------
#  tmp = tempdir()
#  res_grn = sesameAnno_get("Test/3999492009_R01C01_Grn.idat", dest_dir=tmp)
#  res_red = sesameAnno_get("Test/3999492009_R01C01_Red.idat", dest_dir=tmp)

## ----inf10, eval=FALSE--------------------------------------------------------
#  
#  deIdentify(res_grn$dest_file, sprintf("%s/deidentified_Grn.idat", tmp))
#  deIdentify(res_red$dest_file, sprintf("%s/deidentified_Red.idat", tmp))
#  
#  betas1 = getBetas(readIDATpair(sprintf("%s/Test/3999492009_R01C01", tmp)))
#  betas2 = getBetas(readIDATpair(sprintf("%s/deidentified", tmp)))
#  
#  head(betas1[grep('rs',names(betas1))])
#  head(betas2[grep('rs',names(betas2))])

## ----inf11, eval=FALSE--------------------------------------------------------
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  
#  deIdentify(res_grn$dest_file,
#      sprintf("%s/deidentified_Grn.idat", tmp), randomize=TRUE)
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  deIdentify(res_red$dest_file,
#      sprintf("%s/deidentified_Red.idat", tmp), randomize=TRUE)
#  
#  betas1 = getBetas(readIDATpair(sprintf("%s/Test/3999492009_R01C01", tmp)))
#  betas2 = getBetas(readIDATpair(sprintf("%s/deidentified", tmp)))
#  
#  head(betas1[grep('rs',names(betas1))])
#  head(betas2[grep('rs',names(betas2))])
#  

## ----inf12, eval=FALSE--------------------------------------------------------
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  
#  reIdentify(sprintf("%s/deidentified_Grn.idat", tmp),
#      sprintf("%s/reidentified_Grn.idat", tmp))
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  reIdentify(sprintf("%s/deidentified_Red.idat", tmp),
#      sprintf("%s/reidentified_Red.idat", tmp))
#  
#  betas1 = getBetas(readIDATpair(sprintf("%s/Test/3999492009_R01C01", tmp)))
#  betas2 = getBetas(readIDATpair(sprintf("%s/reidentified", tmp)))
#  
#  head(betas1[grep('rs',names(betas1))])
#  head(betas2[grep('rs',names(betas2))])

## -----------------------------------------------------------------------------
sessionInfo()

