## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE
)

## ----install, eval = FALSE----------------------------------------------------
#  ## install from Bioconductor if you haven't already
#  pkgs <- c("LoomExperiment", "hca")
#  pkgs_needed <- pkgs[!pkgs %in% rownames(installed.packages())]
#  BiocManager::install(pkgs_needed)

## ----setup, message = FALSE---------------------------------------------------
library(dplyr)
library(SummarizedExperiment)
library(LoomExperiment)
library(hca)

## ---- eval = FALSE------------------------------------------------------------
#  default_manifest_tbl <- hca::manifest()
#  default_manifest_tbl

## -----------------------------------------------------------------------------
manifest_filter <- hca::filters(
    projectId = list(is = "4a95101c-9ffc-4f30-a809-f04518a23803"),
    fileFormat = list(is = "loom"),
    workflow = list(is = c("optimus_v4.2.2", "optimus_v4.2.3"))
)

## -----------------------------------------------------------------------------
manifest_tibble <- hca::manifest(filters = manifest_filter)
manifest_tibble

## -----------------------------------------------------------------------------
manifest_tibble |>
    dplyr::count(specimen_from_organism.organ)

## -----------------------------------------------------------------------------
manifest_tibble

## -----------------------------------------------------------------------------
file_uuid <- "24a8a323-7ecd-504e-a253-b0e0892dd730"

## -----------------------------------------------------------------------------
file_filter <- hca::filters(
    fileId = list(is = file_uuid)
)

file_tbl <- hca::files(filters = file_filter)

file_tbl

## -----------------------------------------------------------------------------
file_location <-
    file_tbl |>
    hca::files_download()
file_location

## -----------------------------------------------------------------------------
loom <- LoomExperiment::import(file_location)
metadata(loom) |>
    dplyr::glimpse()
colData(loom) |>
    dplyr::as_tibble() |>
    dplyr::glimpse()

## -----------------------------------------------------------------------------
annotated_loom <- optimus_loom_annotation(file_location)
annotated_loom


## new metadata
setdiff(
    names(metadata(annotated_loom)),
    names(metadata(loom))
)
metadata(annotated_loom)$manifest

## new colData columns
setdiff(
    names(colData(annotated_loom)),
    names(colData(loom))
)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

