/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.io.VCFDecoderInterface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public class VCFDecoder
implements VCFDecoderInterface<byte[][]> {
    private static final byte LF = 10;
    private static final byte TAB = 9;
    private static final byte CR = 13;

    @Override
    public byte[][] decode(ByteBuffer buffer) {
        int lineStartPos = buffer.position();
        int limit = buffer.limit();
        int crs = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 13) {
                ++crs;
                continue;
            }
            if (b != 10) continue;
            int lineEndPos = buffer.position();
            if (buffer.limit() < lineEndPos + 1) {
                buffer.position(lineStartPos).limit(lineEndPos);
            } else {
                buffer.position(lineStartPos).limit(lineEndPos + 1);
            }
            byte[] line = this.parseBytes(buffer, lineEndPos - lineStartPos - 1, crs);
            crs = 0;
            if (line != null) {
                buffer.position(lineEndPos);
                buffer.limit(limit);
                lineStartPos = lineEndPos;
            }
            if (line.length == 0) continue;
            byte[][] split = this.splitInTabs(line);
            line = null;
            return split;
        }
        buffer.position(lineStartPos);
        return null;
    }

    private byte[] parseBytes(ByteBuffer buffer, int length, int crs) {
        byte[] bytes = new byte[length - crs];
        int i = 0;
        while (i < length) {
            byte b = buffer.get();
            if (b != 13) {
                bytes[i] = b;
            }
            ++i;
        }
        return bytes;
    }

    private byte[][] splitInTabs(byte[] bytes) {
        Object ret;
        int numTabs = 0;
        ArrayList<Integer> tabs = new ArrayList<Integer>();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 9) {
                ++numTabs;
                tabs.add(i);
            }
            ++i;
        }
        if (numTabs == 0 || bytes[0] == 35 && bytes[1] == 35) {
            ret = new byte[1][bytes.length];
            ret[0] = Arrays.copyOf(bytes, bytes.length);
        } else {
            ret = new byte[numTabs + 1][];
            ret[0] = Arrays.copyOfRange(bytes, 0, (int)((Integer)tabs.get(0)));
            int i2 = 1;
            while (i2 < numTabs) {
                ret[i2] = Arrays.copyOfRange(bytes, (Integer)tabs.get(i2 - 1) + 1, (int)((Integer)tabs.get(i2)));
                ++i2;
            }
            ret[numTabs] = Arrays.copyOfRange(bytes, (Integer)tabs.get(numTabs - 1) + 1, bytes.length);
        }
        tabs.clear();
        tabs = null;
        bytes = null;
        return ret;
    }
}

