/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.Sequence;
import ciat.agrobio.io.FastaDecoder;
import ciat.agrobio.io.FastaIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FastaManager
implements Runnable {
    private BlockingQueue<Sequence> sequences = null;
    private ConcurrentHashMap<Integer, Sequence> staticSequences = null;
    private List<Integer> sequenceIds = null;
    private List<String> sequenceNames = null;
    private AtomicInteger currSequenceId = new AtomicInteger(0);
    public boolean isFastq = false;
    private boolean keepQualities = false;
    private List<String> inputFileNames = null;
    private boolean done = false;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private GeneralTools gTools = GeneralTools.getInstance();

    public FastaManager(boolean keepQualities, List<String> inputFileNames, CountDownLatch startSignal, CountDownLatch doneSignal) {
        this.keepQualities = keepQualities;
        this.inputFileNames = inputFileNames;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.sequences = new LinkedBlockingQueue<Sequence>();
        this.staticSequences = new ConcurrentHashMap();
        this.sequenceIds = new ArrayList<Integer>();
        this.sequenceNames = new ArrayList<String>();
    }

    public void clear() {
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = new LinkedBlockingQueue<Sequence>();
        if (this.staticSequences != null) {
            this.staticSequences.clear();
        }
        this.staticSequences = new ConcurrentHashMap();
        if (this.sequenceIds != null) {
            this.sequenceIds.clear();
        }
        this.sequenceIds = new ArrayList<Integer>();
        if (this.sequenceNames != null) {
            this.sequenceNames.clear();
        }
        this.sequenceNames = new ArrayList<String>();
    }

    public final ConcurrentHashMap<Integer, Sequence> getStaticSequences() {
        return this.staticSequences;
    }

    public final List<Integer> getSequenceIds() {
        return this.sequenceIds;
    }

    public final List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    public boolean hasMore() {
        if (!this.done) {
            return true;
        }
        return !this.sequences.isEmpty();
    }

    private boolean putSequence(Sequence sequence) {
        try {
            this.sequences.put(sequence);
            this.staticSequences.put(sequence.getSequenceId(), sequence);
            this.sequenceIds.add(sequence.getSequenceId());
            this.sequenceNames.add(sequence.getShortName());
            return true;
        }
        catch (Exception e) {
            this.sequences.remove(sequence);
            this.staticSequences.remove(sequence.getSequenceId());
            this.sequenceIds.remove(sequence.getSequenceId());
            this.sequenceNames.remove(sequence.getShortName());
            return false;
        }
    }

    public Sequence getNextSequence() {
        try {
            return this.sequences.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void run() {
        try {
            this.done = false;
            System.err.println(String.valueOf(GeneralTools.time()) + " FastaManager: START READ");
            this.startSignal.countDown();
            ArrayList<File> inputFiles = new ArrayList<File>();
            for (String inputFileName : this.inputFileNames) {
                inputFileName = inputFileName.trim();
                if (!this.isFastq && (inputFileName.endsWith(".fastq") || inputFileName.endsWith(".fq"))) {
                    this.isFastq = true;
                }
                inputFiles.add(new File(inputFileName).getCanonicalFile());
            }
            for (File f : inputFiles) {
                if (f.exists() && f.canRead()) continue;
                System.err.println("\tERROR : File " + f + "\n\tdoes not exist ot cannot be read. Exiting.");
                System.exit(1);
            }
            FastaDecoder decoder = new FastaDecoder();
            FastaIterator<byte[]> iterator = FastaIterator.create(decoder, inputFiles);
            byte[] lastHeader = null;
            ArrayList<byte[]> lastSeq = null;
            Object lastQualSeq = null;
            for (List<byte[]> list : iterator) {
                System.err.println(String.valueOf(GeneralTools.time()) + " FastaManager: Chunk with " + list.size() + " lines.");
                int i = 0;
                if (lastHeader != null) {
                    if (!this.isFastq) {
                        while (i < list.size()) {
                            byte[] line = list.get(i);
                            if (line[0] == 62) break;
                            lastSeq.add(line);
                            ++i;
                        }
                        int seqId = this.gTools.getRandomInteger();
                        while (this.sequenceIds.contains(seqId)) {
                            seqId = this.gTools.getRandomInteger();
                        }
                        Sequence sequence = new Sequence(seqId, lastHeader, this.gTools.concat(lastSeq));
                        this.currSequenceId.incrementAndGet();
                        if (!this.putSequence(sequence)) {
                            this.currSequenceId.decrementAndGet();
                        }
                        lastHeader = null;
                    } else {
                        Sequence sequence;
                        int seqId;
                        byte[] seq = null;
                        byte[] qual = null;
                        if (lastQualSeq != null) {
                            seq = lastQualSeq;
                            if (list.get(i)[0] == 43) {
                                ++i;
                            }
                            qual = list.get(i);
                        } else {
                            seq = list.get(i);
                            ++i;
                            qual = list.get(++i);
                        }
                        if (this.keepQualities) {
                            seqId = this.gTools.getRandomInteger();
                            while (this.sequenceIds.contains(seqId)) {
                                seqId = this.gTools.getRandomInteger();
                            }
                            sequence = new Sequence(seqId, lastHeader, seq, qual);
                            this.currSequenceId.incrementAndGet();
                            if (!this.putSequence(sequence)) {
                                this.currSequenceId.decrementAndGet();
                            }
                        } else {
                            seqId = this.gTools.getRandomInteger();
                            while (this.sequenceIds.contains(seqId)) {
                                seqId = this.gTools.getRandomInteger();
                            }
                            sequence = new Sequence(seqId, lastHeader, seq);
                            this.currSequenceId.incrementAndGet();
                            if (!this.putSequence(sequence)) {
                                this.currSequenceId.decrementAndGet();
                            }
                        }
                        lastHeader = null;
                        lastQualSeq = null;
                        ++i;
                    }
                }
                while (i < list.size()) {
                    Object seq;
                    byte[] line = list.get(i);
                    if (!this.isFastq && line[0] == 62) {
                        seq = new ArrayList<byte[]>();
                        byte[] header = line;
                        while (++i < list.size()) {
                            line = list.get(i);
                            if (line[0] == 62) break;
                            ((ArrayList)seq).add(line);
                        }
                        if (i == list.size()) {
                            lastHeader = header;
                            lastSeq = seq;
                            continue;
                        }
                        int seqId = this.gTools.getRandomInteger();
                        while (this.sequenceIds.contains(seqId)) {
                            seqId = this.gTools.getRandomInteger();
                        }
                        Sequence sequence = new Sequence(seqId, header, this.gTools.concat((ArrayList<byte[]>)seq));
                        this.currSequenceId.incrementAndGet();
                        if (this.putSequence(sequence)) continue;
                        this.currSequenceId.decrementAndGet();
                        continue;
                    }
                    if (this.isFastq && line[0] == 64) {
                        Sequence sequence;
                        seq = null;
                        byte[] qual = null;
                        byte[] header = line;
                        if (++i < list.size()) {
                            seq = list.get(i);
                            if (++i < list.size() && ++i < list.size()) {
                                qual = list.get(i);
                            }
                        }
                        if (i == list.size()) {
                            lastHeader = header;
                            lastQualSeq = seq;
                        } else if (this.keepQualities) {
                            int seqId = this.gTools.getRandomInteger();
                            while (this.sequenceIds.contains(seqId)) {
                                seqId = this.gTools.getRandomInteger();
                            }
                            sequence = new Sequence(seqId, header, (byte[])seq, qual);
                            this.currSequenceId.incrementAndGet();
                            if (!this.putSequence(sequence)) {
                                this.currSequenceId.decrementAndGet();
                            }
                        } else {
                            int seqId = this.gTools.getRandomInteger();
                            while (this.sequenceIds.contains(seqId)) {
                                seqId = this.gTools.getRandomInteger();
                            }
                            sequence = new Sequence(seqId, header, (byte[])seq);
                            this.currSequenceId.incrementAndGet();
                            if (!this.putSequence(sequence)) {
                                this.currSequenceId.decrementAndGet();
                            }
                        }
                        ++i;
                        continue;
                    }
                    ++i;
                }
                list.clear();
                Object var7_9 = null;
            }
            if (lastHeader != null) {
                Sequence sequence;
                if (!this.isFastq) {
                    int n;
                    int n2 = this.gTools.getRandomInteger();
                    while (this.sequenceIds.contains(n)) {
                        n = this.gTools.getRandomInteger();
                    }
                    sequence = new Sequence(n, lastHeader, this.gTools.concat(lastSeq));
                    this.currSequenceId.incrementAndGet();
                    if (!this.putSequence(sequence)) {
                        this.currSequenceId.decrementAndGet();
                    }
                    lastHeader = null;
                } else {
                    if (!this.keepQualities) {
                        int n;
                        int n3 = this.gTools.getRandomInteger();
                        while (this.sequenceIds.contains(n)) {
                            n = this.gTools.getRandomInteger();
                        }
                        sequence = new Sequence(n, lastHeader, (byte[])lastQualSeq);
                        this.currSequenceId.incrementAndGet();
                        if (!this.putSequence(sequence)) {
                            this.currSequenceId.decrementAndGet();
                        }
                    }
                    lastHeader = null;
                    lastQualSeq = null;
                }
            }
            System.err.println(String.valueOf(GeneralTools.time()) + " FastaManager: END READ");
            System.err.println(String.valueOf(GeneralTools.time()) + " FastaManager: " + (this.isFastq ? "FASTQ" : "FASTA"));
            this.done = true;
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

