/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.io.FastaFileDecoderInterface;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FastaIterator<T>
implements Iterable<List<T>> {
    private static final long CHUNK_SIZE = 0x40000000L;
    private final FastaFileDecoderInterface<T> decoder;
    private Iterator<File> files;

    private FastaIterator(FastaFileDecoderInterface<T> decoder, File ... files) {
        this(decoder, Arrays.asList(files));
    }

    private FastaIterator(FastaFileDecoderInterface<T> decoder, List<File> files) {
        this.files = files.iterator();
        this.decoder = decoder;
    }

    public static <T> FastaIterator<T> create(FastaFileDecoderInterface<T> decoder, List<File> files) {
        return new FastaIterator<T>(decoder, files);
    }

    public static <T> FastaIterator<T> create(FastaFileDecoderInterface<T> decoder, File ... files) {
        return new FastaIterator<T>(decoder, files);
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new Iterator<List<T>>(){
            private List<T> entries;
            private long chunkPos = 0L;
            private MappedByteBuffer buffer;
            private FileChannel channel;

            @Override
            public boolean hasNext() {
                if (this.buffer == null || !this.buffer.hasRemaining()) {
                    this.buffer = this.nextBuffer(this.chunkPos);
                    if (this.buffer == null) {
                        return false;
                    }
                }
                Object result = null;
                while (true) {
                    Object t = FastaIterator.this.decoder.decode(this.buffer);
                    result = t;
                    if (t == null) break;
                    if (this.entries == null) {
                        this.entries = new ArrayList();
                    }
                    this.entries.add(result);
                }
                this.chunkPos += (long)this.buffer.position();
                this.buffer = null;
                if (this.entries != null) {
                    return true;
                }
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }

            private MappedByteBuffer nextBuffer(long position) {
                try {
                    if (this.channel == null || this.channel.size() == position) {
                        if (this.channel != null) {
                            this.channel.close();
                            this.channel = null;
                        }
                        if (FastaIterator.this.files.hasNext()) {
                            File file = (File)FastaIterator.this.files.next();
                            this.channel = new RandomAccessFile(file, "r").getChannel();
                            this.chunkPos = 0L;
                            position = 0L;
                        } else {
                            return null;
                        }
                    }
                    long chunkSize = 0x40000000L;
                    if (this.channel.size() - position < chunkSize) {
                        chunkSize = this.channel.size() - position;
                    }
                    return this.channel.map(FileChannel.MapMode.READ_ONLY, this.chunkPos, chunkSize);
                }
                catch (IOException e) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    throw new RuntimeException(e);
                }
            }

            @Override
            public List<T> next() {
                List res = this.entries;
                this.entries = null;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

